/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.asm;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.asm.MethodBuilder;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;

@Requires(value="org.ow2.asm:asm")
public class ClassBuilder {
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private int classVersion = 52;
    private final int access;
    private final Type name;
    @Nullable
    private String signature;
    private Type parent = OBJECT_TYPE;
    private final List<Type> interfaces = new LinkedList<Type>();
    private final List<FieldBuilder> fields = new LinkedList<FieldBuilder>();
    private final List<MethodBuilder> methods = new LinkedList<MethodBuilder>();

    public ClassBuilder(int access, Type name) {
        this.access = access;
        this.name = name;
    }

    public ClassBuilder withClassVersion(int classVersion) {
        this.classVersion = classVersion;
        return this;
    }

    public ClassBuilder withSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public ClassBuilder withParent(Type parent) {
        this.parent = parent;
        return this;
    }

    public ClassBuilder withInterface(Type iFace) {
        this.interfaces.add(iFace);
        return this;
    }

    public FieldBuilder addField(int access, String name, Type desc) {
        FieldBuilder field = new FieldBuilder(access, this, name, desc);
        this.fields.add(field);
        return field;
    }

    public MethodBuilder addMethod(int access, Method method) {
        return this.addMethod(access, method.getName(), Type.getType((Method)method));
    }

    public MethodBuilder addMethod(int access, String name, Type desc) {
        MethodBuilder method = new MethodBuilder(access, this, name, desc);
        this.methods.add(method);
        return method;
    }

    public byte[] build() {
        ClassWriter cw = new ClassWriter(3);
        String[] iFaces = FastStream.of(this.interfaces).map(Type::getInternalName).toArray((String[])new String[0]);
        cw.visit(this.classVersion, this.access, this.name.getInternalName(), this.signature, this.parent.getInternalName(), iFaces);
        for (FieldBuilder field : this.fields) {
            field.build((ClassVisitor)cw);
        }
        for (MethodBuilder method : this.methods) {
            method.build((ClassVisitor)cw);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    public int classVersion() {
        return this.classVersion;
    }

    @Nullable
    public String signature() {
        return this.signature;
    }

    public int access() {
        return this.access;
    }

    public Type name() {
        return this.name;
    }

    public Type parent() {
        return this.parent;
    }

    public List<Type> interfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public static class FieldBuilder {
        private final int access;
        private final ClassBuilder owner;
        private final String name;
        private final Type desc;
        @Nullable
        private String signature;
        @Nullable
        private Object value;

        public FieldBuilder(int access, ClassBuilder owner, String name, Type desc) {
            this.access = access;
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public FieldBuilder withSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public FieldBuilder withValue(Object value) {
            this.value = value;
            return this;
        }

        private void build(ClassVisitor cv) {
            FieldVisitor fv = cv.visitField(this.access, this.name, this.desc.getDescriptor(), this.signature, this.value);
            fv.visitEnd();
        }

        public int access() {
            return this.access;
        }

        public ClassBuilder owner() {
            return this.owner;
        }

        public String name() {
            return this.name;
        }

        public Type desc() {
            return this.desc;
        }

        @Nullable
        public String getSignature() {
            return this.signature;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }
    }
}

