/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.gui.nbt;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.silentchaos512.lib.client.gui.nbt.DisplayNBTList;
import net.silentchaos512.lib.util.NBTToJson;
import net.silentchaos512.lib.util.TextRenderUtils;

public class DisplayNBTScreen
extends Screen {
    final List<String> lines;
    private final CompoundTag nbtCompound;
    private DisplayNBTList displayList;
    private Component header;

    public DisplayNBTScreen(CompoundTag nbt, Component titleIn) {
        super(titleIn);
        this.lines = DisplayNBTScreen.formatNbt(nbt, 0);
        this.nbtCompound = nbt;
        this.header = this.f_96539_;
    }

    protected void m_7856_() {
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
        int scaledWidth = this.f_96541_.m_91268_().m_85445_();
        int scaledHeight = this.f_96541_.m_91268_().m_85446_();
        int width = 100;
        int height = 20;
        Button exportButton = Button.m_253074_((Component)Component.m_237113_((String)"Export to JSON"), b -> {
            JsonObject json = NBTToJson.toJsonObject(this.nbtCompound);
            String message = NBTToJson.writeFile(json);
            this.header = Component.m_237113_((String)message);
        }).m_252987_(scaledWidth - width - 2, scaledHeight - height - 2, width, height).m_253136_();
        this.m_142416_((GuiEventListener)exportButton);
        this.displayList = new DisplayNBTList(this, this.f_96541_, scaledWidth, this.f_96544_, 12, this.f_96544_ - 12, 11);
        this.m_7787_((GuiEventListener)this.displayList);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        assert (this.f_96541_ != null);
        this.displayList.m_88315_(graphics, mouseX, mouseY, partialTicks);
        String titleStr = this.header.getString();
        int scaledWidth = this.f_96541_.m_91268_().m_85445_();
        TextRenderUtils.renderScaled(graphics, this.f_96547_, Component.m_237113_((String)titleStr).m_7532_(), (scaledWidth - this.f_96547_.m_92895_(titleStr)) / 2, 2, 1.0f, 0xFFFFFF, true);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private static List<String> formatNbt(CompoundTag nbt, int depth) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : nbt.m_128431_()) {
            Tag inbt = nbt.m_128423_(key);
            list.addAll(DisplayNBTScreen.formatNbt(key, inbt, depth + 1));
        }
        return list;
    }

    private static List<String> formatNbt(String key, Tag nbt, int depth) {
        ArrayList<String> list = new ArrayList<String>();
        String indentStr = DisplayNBTScreen.indent(depth);
        if (nbt instanceof CompoundTag) {
            DisplayNBTScreen.formatCompound(key, (CompoundTag)nbt, depth, list, indentStr);
        } else if (nbt instanceof CollectionTag) {
            DisplayNBTScreen.formatList(key, (CollectionTag)nbt, depth, list, indentStr);
        } else if (nbt instanceof NumericTag) {
            DisplayNBTScreen.formatNumber(key, (NumericTag)nbt, list, indentStr);
        } else if (nbt instanceof StringTag) {
            String value = nbt.m_7916_();
            list.add(indentStr + DisplayNBTScreen.format(key, value, ChatFormatting.GREEN));
        }
        return list;
    }

    private static void formatCompound(String key, CompoundTag nbt, int depth, List<String> list, String indentStr) {
        if (nbt.m_128456_()) {
            list.add(indentStr + DisplayNBTScreen.format(key, "{}", ChatFormatting.RESET));
        } else {
            list.add(indentStr + DisplayNBTScreen.format(key, "{", ChatFormatting.RESET));
            list.addAll(DisplayNBTScreen.formatNbt(nbt, depth + 1));
            list.add(indentStr + "}" + (String)(key.isEmpty() ? "" : ChatFormatting.DARK_GRAY + " #" + key));
        }
    }

    private static void formatList(String key, CollectionTag nbt, int depth, List<String> list, String indentStr) {
        if (nbt.isEmpty()) {
            list.add(indentStr + DisplayNBTScreen.format(key, "[]", ChatFormatting.RESET));
        } else {
            list.add(indentStr + DisplayNBTScreen.format(key, "[", ChatFormatting.RESET));
            for (Tag element : nbt) {
                list.addAll(DisplayNBTScreen.formatNbt("", element, depth + 1));
            }
            list.add(indentStr + "]" + (String)(key.isEmpty() ? "" : ChatFormatting.DARK_GRAY + " #" + key));
        }
    }

    private static void formatNumber(String key, NumericTag nbt, List<String> list, String indentStr) {
        Number value = nbt.m_8103_();
        String line = indentStr + DisplayNBTScreen.format(key, value, ChatFormatting.LIGHT_PURPLE);
        if (value instanceof Integer) {
            line = line + ChatFormatting.GRAY + String.format(" (0x%X)", value.intValue());
        }
        list.add(line);
    }

    private static String format(String key, Object value, ChatFormatting valueFormat) {
        if (key.isEmpty()) {
            return valueFormat + value.toString();
        }
        return ChatFormatting.GOLD + key + ChatFormatting.RESET + ": " + valueFormat + value;
    }

    private static String indent(int depth) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }
}

