/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.silentchaos512.lib.data.recipe.DamageItemRecipeBuilder;
import net.silentchaos512.lib.data.recipe.ExtendedShapedRecipeBuilder;
import net.silentchaos512.lib.data.recipe.ExtendedShapelessRecipeBuilder;
import net.silentchaos512.lib.util.NameUtils;

public abstract class LibRecipeProvider
extends RecipeProvider {
    private final String modId;

    public LibRecipeProvider(DataGenerator generatorIn, String modId) {
        super(generatorIn.getPackOutput());
        this.modId = modId;
    }

    protected abstract void m_245200_(Consumer<FinishedRecipe> var1);

    protected ResourceLocation modId(String path) {
        return new ResourceLocation(this.modId, path);
    }

    protected void writeConditions(JsonObject json, ICondition ... conditions) {
        if (conditions.length > 0) {
            JsonArray array = new JsonArray();
            for (ICondition condition : conditions) {
                array.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)array);
        }
    }

    protected ExtendedShapedRecipeBuilder shapedBuilder(RecipeCategory category, ItemLike result) {
        return ExtendedShapedRecipeBuilder.vanillaBuilder(category, result, 1);
    }

    protected ExtendedShapedRecipeBuilder shapedBuilder(RecipeCategory category, ItemLike result, int count) {
        return ExtendedShapedRecipeBuilder.vanillaBuilder(category, result, count);
    }

    protected ExtendedShapedRecipeBuilder shapedBuilder(RecipeSerializer<?> serializer, RecipeCategory category, ItemLike result) {
        return ExtendedShapedRecipeBuilder.builder(serializer, category, result, 1);
    }

    protected ExtendedShapedRecipeBuilder shapedBuilder(RecipeSerializer<?> serializer, RecipeCategory category, ItemLike result, int count) {
        return ExtendedShapedRecipeBuilder.builder(serializer, category, result, count);
    }

    protected ExtendedShapelessRecipeBuilder shapelessBuilder(RecipeCategory category, ItemLike result) {
        return ExtendedShapelessRecipeBuilder.vanillaBuilder(category, result, 1);
    }

    protected ExtendedShapelessRecipeBuilder shapelessBuilder(RecipeCategory category, ItemLike result, int count) {
        return ExtendedShapelessRecipeBuilder.vanillaBuilder(category, result, count);
    }

    protected ExtendedShapelessRecipeBuilder shapelessBuilder(RecipeSerializer<?> serializer, RecipeCategory category, ItemLike result) {
        return ExtendedShapelessRecipeBuilder.builder(serializer, category, result, 1);
    }

    protected ExtendedShapelessRecipeBuilder shapelessBuilder(RecipeSerializer<?> serializer, RecipeCategory category, ItemLike result, int count) {
        return ExtendedShapelessRecipeBuilder.builder(serializer, category, result, count);
    }

    protected DamageItemRecipeBuilder damageItemBuilder(RecipeCategory category, ItemLike result) {
        return DamageItemRecipeBuilder.builder(category, result, 1);
    }

    protected DamageItemRecipeBuilder damageItemBuilder(RecipeCategory category, ItemLike result, int count) {
        return DamageItemRecipeBuilder.builder(category, result, count);
    }

    protected DamageItemRecipeBuilder damageItemBuilder(RecipeSerializer<?> serializer, RecipeCategory category, ItemLike result) {
        return DamageItemRecipeBuilder.builder(serializer, category, result, 1);
    }

    protected DamageItemRecipeBuilder damageItemBuilder(RecipeSerializer<?> serializer, RecipeCategory category, ItemLike result, int count) {
        return DamageItemRecipeBuilder.builder(serializer, category, result, count);
    }

    protected void registerCustomRecipe(Consumer<FinishedRecipe> consumer, SimpleCraftingRecipeSerializer<?> serializer) {
        this.registerCustomRecipe(consumer, serializer, NameUtils.fromRecipeSerializer(serializer));
    }

    protected void registerCustomRecipe(Consumer<FinishedRecipe> consumer, SimpleCraftingRecipeSerializer<?> serializer, ResourceLocation recipeId) {
        SpecialRecipeBuilder.m_245676_(serializer).m_126359_(consumer, recipeId.toString());
    }

    protected void smeltingAndBlastingRecipes(Consumer<FinishedRecipe> consumer, String id, ItemLike ingredientIn, ItemLike result, float experienceIn) {
        this.smeltingAndBlastingRecipes(consumer, id, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredientIn}), result, experienceIn);
    }

    protected void smeltingAndBlastingRecipes(Consumer<FinishedRecipe> consumer, String id, TagKey<Item> ingredientIn, ItemLike result, float experienceIn) {
        this.smeltingAndBlastingRecipes(consumer, id, Ingredient.m_204132_(ingredientIn), result, experienceIn);
    }

    protected void smeltingAndBlastingRecipes(Consumer<FinishedRecipe> consumer, String id, Ingredient ingredientIn, ItemLike result, float experienceIn) {
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)ingredientIn, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)experienceIn, (int)100).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_126140_(consumer, this.modId("blasting/" + id));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)ingredientIn, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)experienceIn, (int)200).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_126140_(consumer, this.modId("smelting/" + id));
    }

    protected void compressionRecipes(Consumer<FinishedRecipe> consumer, ItemLike block, ItemLike item, @Nullable ItemLike nugget) {
        this.compressionRecipes(consumer, RecipeCategory.MISC, block, item, nugget);
    }

    protected void compressionRecipes(Consumer<FinishedRecipe> consumer, RecipeCategory category, ItemLike block, ItemLike item, @Nullable ItemLike nugget) {
        String blockName = NameUtils.fromItem(block).m_135815_();
        String itemName = NameUtils.fromItem(item).m_135815_();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)block, (int)1).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), item).m_126132_("has_item", (CriterionTriggerInstance)LibRecipeProvider.m_125977_((ItemLike)item)).m_126140_(consumer, this.modId(itemName + "_from_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)9).m_126209_(block).m_126132_("has_item", (CriterionTriggerInstance)LibRecipeProvider.m_125977_((ItemLike)item)).m_126140_(consumer, this.modId(blockName));
        if (nugget != null) {
            String nuggetName = NameUtils.fromItem(nugget).m_135815_();
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)1).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), nugget).m_126132_("has_item", (CriterionTriggerInstance)LibRecipeProvider.m_125977_((ItemLike)item)).m_126140_(consumer, this.modId(itemName + "_from_nugget"));
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget, (int)9).m_126209_(item).m_126132_("has_item", (CriterionTriggerInstance)LibRecipeProvider.m_125977_((ItemLike)item)).m_126140_(consumer, this.modId(nuggetName));
        }
    }

    protected static InventoryChangeTrigger.TriggerInstance m_206406_(TagKey<Item> p_206407_) {
        return LibRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(p_206407_).m_45077_()});
    }
}

