/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.network.internal;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.item.ILeftClickItem;
import net.silentchaos512.utils.EnumUtils;

public class LeftClickItemPacket {
    private ILeftClickItem.ClickType clickType;
    private InteractionHand hand;

    public LeftClickItemPacket() {
        this.clickType = ILeftClickItem.ClickType.EMPTY;
        this.hand = InteractionHand.MAIN_HAND;
    }

    public LeftClickItemPacket(ILeftClickItem.ClickType clickType, InteractionHand hand) {
        this.clickType = clickType;
        this.hand = hand;
    }

    public ILeftClickItem.ClickType getClickType() {
        return this.clickType;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public static LeftClickItemPacket fromBytes(FriendlyByteBuf buffer) {
        LeftClickItemPacket packet = new LeftClickItemPacket();
        packet.clickType = EnumUtils.byOrdinal((int)buffer.readByte(), ILeftClickItem.ClickType.EMPTY);
        packet.hand = buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return packet;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeByte(this.clickType.ordinal());
        buffer.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
    }

    public static void handle(LeftClickItemPacket packet, Supplier<NetworkEvent.Context> context) {
        ItemStack heldItem;
        ServerPlayer player = context.get().getSender();
        if (player != null && !(heldItem = player.m_21120_(packet.hand)).m_41619_() && heldItem.m_41720_() instanceof ILeftClickItem) {
            ILeftClickItem item = (ILeftClickItem)heldItem.m_41720_();
            if (packet.clickType == ILeftClickItem.ClickType.EMPTY) {
                item.onItemLeftClickSL(player.m_9236_(), (Player)player, packet.hand);
            } else if (packet.clickType == ILeftClickItem.ClickType.BLOCK) {
                item.onItemLeftClickBlockSL(player.m_9236_(), (Player)player, packet.hand);
            } else {
                SilentLib.LOGGER.error("Unknown ILeftClickItem.ClickType: {}", (Object)packet.clickType);
            }
        }
        context.get().setPacketHandled(true);
    }
}

