/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.morebeautifulplates.datagen;

import com.kreezcraft.morebeautifulplates.datagen.assets.PlateBlockstateProvider;
import com.kreezcraft.morebeautifulplates.datagen.assets.PlateItemModelProvider;
import com.kreezcraft.morebeautifulplates.datagen.assets.PlateLanguageProvider;
import com.kreezcraft.morebeautifulplates.datagen.data.PlateBlockTagProvider;
import com.kreezcraft.morebeautifulplates.datagen.data.PlateLootProvider;
import com.kreezcraft.morebeautifulplates.datagen.data.PlateRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlateDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new PlateLootProvider(packOutput));
            generator.addProvider(true, (DataProvider)new PlateRecipeProvider(packOutput));
            generator.addProvider(true, (DataProvider)new PlateBlockTagProvider(packOutput, lookupProvider, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new PlateLanguageProvider(packOutput));
            generator.addProvider(true, (DataProvider)new PlateBlockstateProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new PlateItemModelProvider(packOutput, helper));
        }
    }
}

