/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorChoiceLabel;
import mcjty.lib.gui.widgets.ColorSelector;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.FloatField;
import mcjty.lib.gui.widgets.IconHolder;
import mcjty.lib.gui.widgets.IconRender;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.IntegerField;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TabbedPanel;
import mcjty.lib.gui.widgets.TagSelector;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;

public class Widgets {
    private static final Map<String, Supplier<Widget<?>>> FACTORIES = new HashMap();

    @Nullable
    public static Widget<?> createWidget(String type) {
        Supplier<Widget<?>> function = FACTORIES.get(type);
        if (function == null) {
            return null;
        }
        return function.get();
    }

    public static Panel positional() {
        return new Panel().layout(new PositionalLayout());
    }

    public static Panel horizontal() {
        return new Panel().layout(new HorizontalLayout());
    }

    public static Panel horizontal(int margin, int spacing) {
        return new Panel().layout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(margin)).setSpacing(spacing));
    }

    public static Panel vertical() {
        return new Panel().layout(new VerticalLayout());
    }

    public static Panel vertical(int margin, int spacing) {
        return new Panel().layout((Layout)((VerticalLayout)new VerticalLayout().setVerticalMargin(margin)).setSpacing(spacing));
    }

    public static Button button(int x, int y, int w, int h, String text) {
        return (Button)((Button)new Button().hint(x, y, w, h)).text(text);
    }

    public static Button button(String text) {
        return (Button)new Button().text(text);
    }

    public static TextField textfield(int x, int y, int w, int h) {
        return (TextField)new TextField().hint(x, y, w, h);
    }

    public static Label label(int x, int y, int w, int h, String text) {
        return (Label)((Label)new Label().hint(x, y, w, h)).text(text);
    }

    public static Label label(String text) {
        return (Label)new Label().text(text);
    }

    public static ImageChoiceLabel imageChoice(int x, int y, int w, int h) {
        return (ImageChoiceLabel)new ImageChoiceLabel().hint(x, y, w, h);
    }

    public static WidgetList list(int x, int y, int w, int h) {
        return (WidgetList)new WidgetList().hint(x, y, w, h);
    }

    public static Slider slider(int x, int y, int w, int h) {
        return (Slider)new Slider().hint(x, y, w, h);
    }

    static {
        FACTORIES.put("blockrender", BlockRender::new);
        FACTORIES.put("button", Button::new);
        FACTORIES.put("label", Label::new);
        FACTORIES.put("choicelabel", ChoiceLabel::new);
        FACTORIES.put("colorchoicelabel", ColorChoiceLabel::new);
        FACTORIES.put("colorselector", ColorSelector::new);
        FACTORIES.put("energybar", EnergyBar::new);
        FACTORIES.put("iconholder", IconHolder::new);
        FACTORIES.put("iconrender", IconRender::new);
        FACTORIES.put("imagechoicelabel", ImageChoiceLabel::new);
        FACTORIES.put("imagelabel", ImageLabel::new);
        FACTORIES.put("panel", Panel::new);
        FACTORIES.put("scrollablelabel", ScrollableLabel::new);
        FACTORIES.put("slider", Slider::new);
        FACTORIES.put("tabbedpanel", TabbedPanel::new);
        FACTORIES.put("textfield", TextField::new);
        FACTORIES.put("integerfield", IntegerField::new);
        FACTORIES.put("floatfield", FloatField::new);
        FACTORIES.put("togglebutton", ToggleButton::new);
        FACTORIES.put("widgetlist", WidgetList::new);
        FACTORIES.put("tagselector", TagSelector::new);
    }
}

