/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.McJtyLib;
import mcjty.lib.blockcommands.CommandInfo;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketSendResultToClient(BlockPos pos, String command, List list) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mcjtylib", "sendresulttoclient");

    public static PacketSendResultToClient create(FriendlyByteBuf buf) {
        ArrayList list;
        BlockPos pos = buf.m_130135_();
        String command = buf.m_130136_(Short.MAX_VALUE);
        CommandInfo info = McJtyLib.getCommandInfo(command);
        if (info == null) {
            throw new IllegalStateException("Command '" + command + "' is not registered!");
        }
        Function<FriendlyByteBuf, FriendlyByteBuf> deserializer = info.deserializer();
        int size = buf.readInt();
        if (size != -1) {
            list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                list.add(deserializer.apply(buf));
            }
        } else {
            list = null;
        }
        return new PacketSendResultToClient(pos, command, list);
    }

    public static PacketSendResultToClient create(BlockPos pos, String command, List list) {
        return new PacketSendResultToClient(pos, command, new ArrayList(list));
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.command);
        CommandInfo info = McJtyLib.getCommandInfo(this.command);
        if (info == null) {
            throw new IllegalStateException("Command '" + this.command + "' is not registered!");
        }
        BiConsumer<FriendlyByteBuf, FriendlyByteBuf> serializer = info.serializer();
        if (serializer == null) {
            throw new IllegalStateException("Command '" + this.command + "' is not registered!");
        }
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (Object item : this.list) {
                serializer.accept(buf, (FriendlyByteBuf)item);
            }
        }
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            BlockEntity te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            if (te instanceof GenericTileEntity) {
                GenericTileEntity generic = (GenericTileEntity)te;
                generic.handleListFromServer(this.command, SafeClientTools.getClientPlayer(), TypedMap.EMPTY, this.list);
            } else {
                Logging.logError("Can't handle command '" + this.command + "'!");
            }
        });
    }
}

