/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.mysticalagriculture.api.crafting.IEnchanterRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.EnchanterRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.EnchanterCrafting")
@ZenRegister
public final class EnchanterCrafting
implements IRecipeManager<IEnchanterRecipe> {
    private static final EnchanterCrafting INSTANCE = new EnchanterCrafting();

    public RecipeType<IEnchanterRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.ENCHANTER.get();
    }

    @ZenCodeType.Method
    public static void addRecipe(String name, String enchantmentID, IItemStack[] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentID));
        EnchanterRecipe recipe = new EnchanterRecipe(id, EnchanterCrafting.toIngredientsList((IIngredient[])inputs), Arrays.stream(inputs).map(IItemStack::getAmount).toList(), enchantment);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void remove(String enchantmentID) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)INSTANCE, recipe -> {
            Enchantment enchantment = recipe.getEnchantment();
            return enchantment != null && Objects.equals(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment), new ResourceLocation(enchantmentID));
        }));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... iingredients) {
        NonNullList ingredients = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);
        for (int i = 0; i < iingredients.length; ++i) {
            ingredients.set(i, (Object)iingredients[i].asVanillaIngredient());
        }
        return ingredients;
    }
}

