/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.connector;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;

public class WireSection {
    private static final Map<String, WireSection> cache = new HashMap<String, WireSection>();
    private final float thickness;
    private final float length;
    private final float endYOffset;
    private final float vOffset;

    public WireSection(float length, float thickness, float endYOffset, float vOffset) {
        this.thickness = thickness;
        this.length = length;
        this.endYOffset = endYOffset;
        this.vOffset = vOffset;
    }

    public void render(VertexConsumer consumer, PoseStack poseStack, int packedLight, float yOffset) {
        float ht = this.thickness / 2.0f;
        for (int i = -1; i <= 1; i += 2) {
            this.addVertex(consumer, ht, ht * (float)i + yOffset, 0.0f, 0.0f, 0.5f + this.vOffset, poseStack, packedLight);
            this.addVertex(consumer, -ht, -ht * (float)i + yOffset, 0.0f, 0.0f, 0.0f + this.vOffset, poseStack, packedLight);
            this.addVertex(consumer, -ht, -ht * (float)i + this.endYOffset + yOffset, this.length * 1.01f, 1.0f, 0.0f + this.vOffset, poseStack, packedLight);
            this.addVertex(consumer, ht, ht * (float)i + this.endYOffset + yOffset, this.length * 1.01f, 1.0f, 0.5f + this.vOffset, poseStack, packedLight);
        }
    }

    private void addVertex(VertexConsumer consumer, float x, float y, float z, float u, float v, PoseStack poseStack, int packedLight) {
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public String name() {
        return this.thickness + "," + this.length + "," + this.endYOffset + "," + this.vOffset;
    }

    public static WireSection getOrCreate(float length, float thickness, float endYOffset, float vOffset) {
        return cache.computeIfAbsent(thickness + "," + length + "," + endYOffset + "," + vOffset, s -> new WireSection(length, thickness, endYOffset, vOffset));
    }
}

