/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.nuclear.reactor.fuelacceptor;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.antarcticgardens.cna.CNATags;
import org.antarcticgardens.cna.CreateNewAge;
import org.antarcticgardens.cna.content.nuclear.reactor.RodFindingReactorBlockEntity;
import org.antarcticgardens.cna.content.nuclear.reactor.rod.ReactorRodBlockEntity;

public abstract class ReactorFuelAcceptorBlockEntity
extends RodFindingReactorBlockEntity {
    public SimpleContainer container = new FuelAcceptorContainer(3);
    int ticks = 0;

    public ReactorFuelAcceptorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("contents", (Tag)this.container.m_7927_());
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.container.m_7797_(compound.m_128437_("contents", 10));
        super.read(compound, clientPacket);
    }

    public void destroy() {
        super.destroy();
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.container.m_8020_(i));
        }
    }

    public void tick(BlockPos pos, Level world, BlockState state) {
        --this.ticks;
        if (this.ticks <= 0) {
            this.ticks = 20;
            LinkedList<ReactorRodBlockEntity> rods = new LinkedList<ReactorRodBlockEntity>();
            for (Direction dir : Direction.values()) {
                this.findRods(rods, dir);
            }
            if (rods.isEmpty()) {
                return;
            }
            AtomicInteger have = new AtomicInteger();
            int hadBefore = 0;
            for (ReactorRodBlockEntity rod : rods) {
                hadBefore += rod.fuel;
            }
            AtomicInteger totalNeeded = new AtomicInteger(345600 * rods.size() - hadBefore);
            for (int i = 0; i < this.container.m_6643_(); ++i) {
                ItemStack stack = this.container.m_8020_(i);
                if (!stack.m_204117_(CNATags.Item.NUCLEAR_FUEL.tag)) continue;
                stack.m_204131_().forEach(itemTagKey -> {
                    String path;
                    if (itemTagKey.f_203868_().m_135827_().equals("create_new_age") && (path = itemTagKey.f_203868_().m_135815_()).startsWith("nuclear/energy_")) {
                        try {
                            int energy = Integer.parseInt(path.substring(15));
                            int total = (int)Math.min((double)stack.m_41613_(), (double)(totalNeeded.get() / energy));
                            totalNeeded.addAndGet(-energy * total);
                            have.addAndGet(energy * total);
                            stack.m_41774_(total);
                        }
                        catch (NumberFormatException e) {
                            CreateNewAge.LOGGER.error("BAD TAG " + String.valueOf(itemTagKey) + " on item " + stack.m_41611_().getString(), (Throwable)e);
                        }
                    }
                });
            }
            this.m_6596_();
            int target = (hadBefore + have.get()) / rods.size();
            for (ReactorRodBlockEntity rod : rods) {
                rod.fuel = target;
            }
        }
    }

    private class FuelAcceptorContainer
    extends SimpleContainer {
        FuelAcceptorContainer(int size) {
            super(size);
        }

        public boolean m_7013_(int index, ItemStack stack) {
            return stack.m_204117_(CNATags.Item.NUCLEAR_FUEL.tag);
        }
    }
}

