/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.IDynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;

public class DynamicRenderTracker
implements IDynamicRenderTracker {
    private static final int DYNAMIC_CHECK_WINDOW_TICKS = 100;
    private static final int MAX_ITEM_CHANGES_IN_WINDOW = 4;
    private long lastItemChangeTime = 0L;
    private final int[] itemChangeExpirationTimes = new int[4];
    private boolean dynamicRenderer = false;
    private boolean fullyDynamic = false;
    private final List<ItemStack> lastRenderedItems = new ArrayList<ItemStack>();
    private final StorageBlockEntity storageBlockEntity;

    public DynamicRenderTracker(StorageBlockEntity storageBlockEntity) {
        this.storageBlockEntity = storageBlockEntity;
    }

    @Override
    public void onRenderInfoUpdated(RenderInfo ri) {
        if (this.getLevel().f_46443_) {
            RenderInfo.ItemDisplayRenderInfo itemDisplayRenderInfo = ri.getItemDisplayRenderInfo();
            List displayItems = itemDisplayRenderInfo.getDisplayItems();
            if (displayItems.isEmpty()) {
                this.lastRenderedItems.clear();
                this.dynamicRenderer = false;
                return;
            }
            if (this.renderedItemsHaventChanged(displayItems)) {
                return;
            }
            this.updateDynamicFlags(displayItems);
        } else {
            WorldHelper.notifyBlockUpdate((BlockEntity)this.storageBlockEntity);
        }
    }

    private void updateDynamicFlags(List<RenderInfo.DisplayItem> displayItems) {
        this.lastRenderedItems.clear();
        displayItems.forEach(displayItem -> this.lastRenderedItems.add(displayItem.getItem()));
        boolean wasDynamic = this.dynamicRenderer;
        boolean wasFullyDynamic = this.fullyDynamic;
        this.fullyDynamic = !displayItems.isEmpty();
        this.dynamicRenderer = false;
        for (RenderInfo.DisplayItem displayItem2 : displayItems) {
            if (this.hasItemModelCustomRenderer(displayItem2.getItem())) {
                this.dynamicRenderer = true;
                continue;
            }
            this.fullyDynamic = false;
        }
        if (!this.updateItemChangeExpirations()) {
            this.dynamicRenderer = true;
            this.fullyDynamic = true;
        }
        if (this.dynamicRenderer != wasDynamic || this.fullyDynamic != wasFullyDynamic) {
            WorldHelper.notifyBlockUpdate((BlockEntity)this.storageBlockEntity);
        }
    }

    private boolean renderedItemsHaventChanged(List<RenderInfo.DisplayItem> displayItems) {
        if (this.lastRenderedItems.size() != displayItems.size()) {
            return false;
        }
        for (int i = 0; i < this.lastRenderedItems.size(); ++i) {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.lastRenderedItems.get(i), (ItemStack)displayItems.get(i).getItem())) continue;
            return false;
        }
        return true;
    }

    private boolean hasItemModelCustomRenderer(ItemStack item) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        BakedModel model = itemRenderer.m_174264_(item, null, (LivingEntity)minecraft.f_91074_, 0);
        return model.m_7521_();
    }

    private boolean updateItemChangeExpirations() {
        boolean timeSet = false;
        int timeDiff = (int)Math.min(100L, this.getLevel().m_46467_() - this.lastItemChangeTime);
        this.lastItemChangeTime = this.getLevel().m_46467_();
        for (int i = 0; i < this.itemChangeExpirationTimes.length; ++i) {
            int val = Math.max(0, this.itemChangeExpirationTimes[i] - timeDiff);
            if (!timeSet && val == 0) {
                timeSet = true;
                val = 100;
            }
            this.itemChangeExpirationTimes[i] = val;
        }
        return timeSet;
    }

    private Level getLevel() {
        return this.storageBlockEntity.m_58904_();
    }

    @Override
    public boolean isDynamicRenderer() {
        return this.dynamicRenderer;
    }

    @Override
    public boolean isFullyDynamicRenderer() {
        return this.fullyDynamic;
    }
}

