/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;

public abstract class StorageRenderer<T extends StorageBlockEntity>
implements BlockEntityRenderer<T> {
    private long lastCacheTime = -1L;
    private boolean holdsItemThatShowsUpgrades = false;
    private boolean holdsStorageToolSetToToggleUpgrades = false;
    private boolean holdsItemThatShowsHiddenTiers = false;
    private boolean holdsItemThatShowsFillLevels = false;
    private boolean holdsToolInToggleLockOrLockDisplay = false;
    private boolean holdsToolInToggleFillLevelDisplay = false;

    protected boolean holdsItemThatShowsUpgrades() {
        this.refreshCache();
        return this.holdsItemThatShowsUpgrades;
    }

    public boolean holdsItemThatShowsFillLevels() {
        return this.holdsItemThatShowsFillLevels;
    }

    private void refreshCache() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && level.m_46467_() != this.lastCacheTime) {
            this.lastCacheTime = level.m_46467_();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                this.holdsItemThatShowsUpgrades = false;
                this.holdsStorageToolSetToToggleUpgrades = false;
                this.holdsItemThatShowsHiddenTiers = false;
                this.holdsToolInToggleLockOrLockDisplay = false;
                return;
            }
            boolean holdsStorageTool = this.holdsItem(player, this::isStorageTool);
            this.holdsStorageToolSetToToggleUpgrades = holdsStorageTool && InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).map(item -> StorageToolItem.getMode(item) == StorageToolItem.Mode.UPGRADES_DISPLAY).orElse(false) != false;
            this.holdsItemThatShowsUpgrades = holdsStorageTool || this.holdsItem(player, this::isUpgrade);
            this.holdsItemThatShowsFillLevels = holdsStorageTool || this.holdsItem(player, this::isStorageTierUpgrade) || this.holdsItem(player, stack -> this.isUpgrade((ItemStack)stack) && stack.m_41720_() instanceof StackUpgradeItem);
            this.holdsItemThatShowsHiddenTiers = holdsStorageTool && InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).map(item -> StorageToolItem.getMode(item) == StorageToolItem.Mode.TIER_DISPLAY).orElse(false) != false || this.holdsItem(player, this::isStorageTierUpgrade);
            this.holdsToolInToggleLockOrLockDisplay = holdsStorageTool && InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).map(item -> {
                StorageToolItem.Mode mode = StorageToolItem.getMode(item);
                return mode == StorageToolItem.Mode.LOCK_DISPLAY || mode == StorageToolItem.Mode.LOCK;
            }).orElse(false) != false;
            this.holdsToolInToggleFillLevelDisplay = holdsStorageTool && InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).map(item -> StorageToolItem.getMode(item) == StorageToolItem.Mode.FILL_LEVEL_DISPLAY).orElse(false) != false;
        }
    }

    public boolean holdsItemThatShowsHiddenTiers() {
        this.refreshCache();
        return this.holdsItemThatShowsHiddenTiers;
    }

    public boolean holdsToolInToggleLockOrLockDisplay() {
        this.refreshCache();
        return this.holdsToolInToggleLockOrLockDisplay;
    }

    public boolean holdsToolInToggleFillLevelDisplay() {
        this.refreshCache();
        return this.holdsToolInToggleFillLevelDisplay;
    }

    private boolean holdsItem(LocalPlayer player, Predicate<ItemStack> itemMatcher) {
        return itemMatcher.test(player.m_21120_(InteractionHand.MAIN_HAND)) || itemMatcher.test(player.m_21120_(InteractionHand.OFF_HAND));
    }

    private boolean isStorageTool(ItemStack stack) {
        return stack.m_41720_() == ModItems.STORAGE_TOOL.get();
    }

    private boolean isUpgrade(ItemStack stack) {
        return stack.m_41720_() instanceof UpgradeItemBase && StorageRenderer.isStorageItem(stack.m_41720_());
    }

    private static boolean isStorageItem(Item item) {
        return RegistryHelper.getItemKey((Item)item).m_135827_().equals("sophisticatedstorage");
    }

    private boolean isStorageTierUpgrade(ItemStack stack) {
        return stack.m_41720_() instanceof StorageTierUpgradeItem;
    }

    public boolean shouldShowDisabledUpgradesDisplay(T storageBlockEntity) {
        this.refreshCache();
        return this.holdsStorageToolSetToToggleUpgrades && !((StorageBlockEntity)storageBlockEntity).shouldShowUpgrades();
    }
}

