/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="forgeendertech", value={Dist.CLIENT})
public class DevInfo
implements IGuiOverlay {
    public static DevInfo INSTANCE = new DevInfo();
    static final GameTime UPDATE_INTERVAL = GameTime.quaterSecond();
    static final GameTime EXCEPTION_PRINT_INTERVAL = GameTime.seconds(10);
    protected static float rayTraceDistance = 10.0f;
    protected static boolean showInventoryTooltip = false;
    protected static boolean renderGameOverlay = false;
    protected static boolean hotKeyWasDown = false;
    private static HitResult rayTraceResult = null;

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.Key event) {
        if (ForgeEndertech.isDebugMode() && Minecraft.m_91087_().f_91073_ != null) {
            int hotKey = 281;
            if (GameKeys.isDown(281)) {
                if (!hotKeyWasDown && GameKeys.isShiftDown()) {
                    showInventoryTooltip = !showInventoryTooltip;
                    renderGameOverlay = !renderGameOverlay;
                }
                hotKeyWasDown = true;
            } else {
                hotKeyWasDown = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        if (!showInventoryTooltip) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_()) {
            List lines = event.getToolTip();
            DevInfo.addItemInfo(stack, lines);
        }
    }

    private DevInfo() {
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        block11: {
            if (!renderGameOverlay) {
                return;
            }
            Minecraft mc = gui.getMinecraft();
            PoseStack pose = guiGraphics.m_280168_();
            if (mc.f_91080_ == null) {
                try {
                    boolean shouldRecalcTraceResult;
                    ArrayList<Component> lines = new ArrayList<Component>();
                    DevInfo.addWorldInfo(mc.f_91073_, lines);
                    lines.add((Component)Component.m_237113_((String)""));
                    boolean bl = shouldRecalcTraceResult = rayTraceResult == null || UPDATE_INTERVAL.pastIn((Level)mc.f_91073_);
                    if (shouldRecalcTraceResult) {
                        rayTraceResult = mc.f_91066_.f_92091_.m_90857_() ? mc.f_91077_ : (HitResult)ForgeEntity.rayTraceBlockBeingLookedAt((Entity)mc.f_91074_, ClipContext.Block.VISUAL, ClipContext.Fluid.ANY, partialTick, rayTraceDistance).orElse(null);
                    }
                    if (rayTraceResult != null) {
                        switch (rayTraceResult.m_6662_()) {
                            case BLOCK: {
                                if (!(rayTraceResult instanceof BlockHitResult)) break;
                                DevInfo.addBlockInfo(mc.f_91073_, ((BlockHitResult)rayTraceResult).m_82425_(), lines);
                                break;
                            }
                            case ENTITY: {
                                if (!(rayTraceResult instanceof EntityHitResult)) break;
                                DevInfo.addEntityInfo(((EntityHitResult)rayTraceResult).m_82443_(), lines);
                                break;
                            }
                        }
                    }
                    pose.m_85836_();
                    int color = -2130706433;
                    int x = 2;
                    int y = 2;
                    int step = 10;
                    for (Component line : lines) {
                        guiGraphics.m_280488_(mc.f_91062_, line.getString(), x, y, color);
                        y += step;
                    }
                    pose.m_85849_();
                }
                catch (Exception e) {
                    if (!EXCEPTION_PRINT_INTERVAL.pastIn((Level)mc.f_91073_)) break block11;
                    ForgeEndertech.debugMsg(e.toString());
                }
            }
        }
    }

    protected static void addCaptionLine(List<Component> lines, String caption) {
        lines.add((Component)Component.m_237113_((String)("==" + caption + "==")));
    }

    protected static void addInfoLine(List<Component> lines, String caption, Object value) {
        lines.add((Component)DevInfo.caption(caption).m_130946_(String.valueOf(value)));
    }

    protected static void addWorldInfo(ClientLevel level, List<Component> lines) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos pos = player.m_20183_();
        BiomeId biome = BiomeId.from((LevelAccessor)level, pos);
        GameWorld.WorldData data = GameWorld.getData((LevelAccessor)level);
        IWind wind = GameWorld.getWindAt((Level)level, pos);
        DevInfo.addCaptionLine(lines, "World Info");
        DevInfo.addInfoLine(lines, "Biome", biome.toString());
        DevInfo.addInfoLine(lines, "Wind", Float.valueOf(wind.getStrengthIn(player.m_6350_())));
        DevInfo.addInfoLine(lines, "isRaining", level.m_46471_());
        DevInfo.addInfoLine(lines, "Level", "rain = " + level.f_46438_ + ", thunder = " + level.f_46440_);
        DevInfo.addInfoLine(lines, "SmokeParticles", data.smokeParticlesCount);
        DevInfo.addInfoLine(lines, "GameTime", level.m_46467_());
    }

    protected static void addBlockInfo(ClientLevel level, BlockPos pos, List<Component> lines) {
        BlockState state = level.m_8055_(pos);
        UnitId id = UnitId.from(state);
        DevInfo.addCaptionLine(lines, "Block Info");
        lines.add((Component)DevInfo.formatedId(id));
        DevInfo.addInfoLine(lines, "State", state);
        if (rayTraceResult instanceof BlockHitResult) {
            Direction face;
            boolean solid = state.m_60783_((BlockGetter)level, pos, face = ((BlockHitResult)rayTraceResult).m_82434_());
            DevInfo.addInfoLine(lines, "Side", face + " (" + (solid ? "solid" : "not solid") + ")");
        }
        DevInfo.addInfoLine(lines, "Sky", "canSeeSky=" + ForgeBlock.isUnderOpenSky((Level)level, pos) + " isUnderRain=" + ForgeBlock.isUnderRain((Level)level, pos));
        DevInfo.addInfoLine(lines, "BlockPos", Args.join(Args.get("x", pos.m_123341_()), Args.get("y", pos.m_123342_()), Args.get("z", pos.m_123343_())));
        DevInfo.addInfoLine(lines, "Shape", state.m_60808_((BlockGetter)level, pos));
        DevInfo.addInfoLine(lines, "CollisionShape", state.m_60812_((BlockGetter)level, pos));
        if (state.m_60823_()) {
            DevInfo.addInfoLine(lines, "Ticks", "randomlyTicking");
        }
        Optional.ofNullable(level.m_7702_(pos)).ifPresent(tile -> {
            DevInfo.addInfoLine(lines, "TileEntity", tile);
            DevInfo.addCompoundInfo(tile.m_187482_(), lines, IEmitter.COMMON_ACTIVE_TAG_NAME);
        });
    }

    static void addEntityInfo(Entity entity, List<Component> lines) {
        DevInfo.addCaptionLine(lines, "Entity Info");
        DevInfo.addInfoLine(lines, "id", ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
        DevInfo.addInfoLine(lines, "name", entity.m_7755_());
        DevInfo.addInfoLine(lines, "isUnderRain", ForgeEntity.isUnderRain(entity));
        DevInfo.addCompoundInfo(entity.m_20240_(new CompoundTag()), lines, IEmitter.COMMON_ACTIVE_TAG_NAME);
    }

    protected static void addItemInfo(ItemStack stack, List<Component> lines) {
        Item item = stack.m_41720_();
        UnitId unitId = UnitId.from(item);
        if (stack.m_41763_()) {
            DevInfo.addInfoLine(lines, "Durability", stack.m_41776_());
        }
        lines.add((Component)DevInfo.formatedId(unitId));
        Optional.of(ForgeHooks.getBurnTime((ItemStack)stack, null)).filter(ticks -> ticks != 0).map(ticks -> ticks + " (carbon: " + (double)ticks.intValue() / 1600.0 + ")").ifPresent(string -> DevInfo.addInfoLine(lines, "BurnTime", string));
        DevInfo.addInfoLine(lines, "Category", CreativeModeTabs.m_257478_().stream().filter(tab -> tab.m_260957_().stream().anyMatch(it -> it.m_150930_(item))).findFirst().map(tab -> tab.m_40786_().getString()).orElse("none"));
        if (GameKeys.isShiftDown()) {
            DevInfo.addInfoLine(lines, "ItemTags", item.m_204114_().m_203616_().map(TagKey::f_203868_).toList());
            if (item instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                DevInfo.addInfoLine(lines, "FluidTags", bucket.getFluid().m_205069_().m_203616_().map(TagKey::f_203868_).toList());
            }
        }
        if (GameKeys.isControlDown()) {
            DevInfo.addCompoundInfo(stack.m_41783_(), lines, name -> true);
        }
    }

    protected static void addCompoundInfo(CompoundTag compound, List<Component> lines, Predicate<String> name) {
        if (compound != null) {
            lines.add((Component)DevInfo.caption("NBT"));
            for (String key : compound.m_128431_()) {
                TagHelper.Types type = TagHelper.getType(compound, key);
                if (!name.test(key) || !type.isOrdinal() && type != TagHelper.Types.STRING) continue;
                String line = type + " " + key;
                line = line + " = " + compound.m_128423_(key);
                lines.add((Component)DevInfo.literal(line));
            }
        } else {
            lines.add((Component)Component.m_237113_((String)"no NBT"));
        }
    }

    protected static MutableComponent caption(String caption) {
        return Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)caption).m_130940_(ChatFormatting.ITALIC)).m_130946_(": ");
    }

    protected static MutableComponent literal(String string) {
        return Component.m_237113_((String)string).m_130940_(ChatFormatting.RESET);
    }

    protected static MutableComponent formatedId(UnitId id) {
        return DevInfo.caption("ID").m_7220_((Component)DevInfo.literal(id.toString()));
    }
}

