/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.DimensionId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public final class Dimensions
extends Enum<Dimensions> {
    public static final /* enum */ Dimensions THE_NETHER = new Dimensions((ResourceKey<Level>)Level.f_46429_, "netherrack");
    public static final /* enum */ Dimensions OVERWORLD = new Dimensions((ResourceKey<Level>)Level.f_46428_, "#minecraft:stone_ore_replaceables");
    public static final /* enum */ Dimensions THE_END = new Dimensions((ResourceKey<Level>)Level.f_46430_, "end_stone");
    public final DimensionId dimensionId;
    public final UnitId replaceableBlockId;
    public static final String DIM_LIST_SYNTAX = "Dimension is specified by its registry name (e.g: minecraft:overworld, minecraft:the_nether, minecraft:the_end, etc.)\nEach dimension must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.";
    private static final /* synthetic */ Dimensions[] $VALUES;

    public static Dimensions[] values() {
        return (Dimensions[])$VALUES.clone();
    }

    public static Dimensions valueOf(String name) {
        return Enum.valueOf(Dimensions.class, name);
    }

    private Dimensions(ResourceKey<Level> registryKey, String replaceableBlockId) {
        this.dimensionId = DimensionId.from(registryKey);
        this.replaceableBlockId = UnitId.from(replaceableBlockId);
        assert (replaceableBlockId != null);
    }

    public static Optional<DimensionId> findByName(String dimensionName) {
        try {
            return Optional.of(DimensionId.from(new ResourceLocation(dimensionName)));
        }
        catch (Exception e) {
            ForgeEndertech.getInstance().getLogger().error("Invalid dimension name: '{}'", (Object)dimensionName);
            return Optional.empty();
        }
    }

    public static CommonCollect.BlackWhiteList<DimensionId> from(UnitConfig config, String category, String comment) {
        return Dimensions.from(config, category, comment, new String[0], new String[0]);
    }

    public static CommonCollect.BlackWhiteList<DimensionId> from(UnitConfig config, String category, String comment, String[] blackList, String[] whiteList) {
        category = IHaveConfig.expandClassCategory(Dimensions.class, category);
        if (config != null) {
            config.setCategoryComment(category, comment + "\nDimension is specified by its registry name (e.g: minecraft:overworld, minecraft:the_nether, minecraft:the_end, etc.)\nEach dimension must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.");
        }
        List<DimensionId> black = Dimensions.readFrom(config, category, "blackList", "", blackList);
        List<DimensionId> white = Dimensions.readFrom(config, category, "whiteList", "", whiteList);
        return new CommonCollect.BlackWhiteList<DimensionId>(black, white);
    }

    public static List<DimensionId> readFrom(UnitConfig config, String category, String key, String comment, String[] defaultValues) {
        if (config == null) {
            return Collections.emptyList();
        }
        String[] strArray = config.getStrArray(category, key, defaultValues, comment);
        ArrayList<DimensionId> list = new ArrayList<DimensionId>();
        for (String str : strArray) {
            if ((str = str.trim()).isEmpty()) continue;
            Dimensions.findByName(str).ifPresent(list::add);
        }
        return list;
    }

    private static /* synthetic */ Dimensions[] $values() {
        return new Dimensions[]{THE_NETHER, OVERWORLD, THE_END};
    }

    static {
        $VALUES = Dimensions.$values();
    }
}

