/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.network.message.SyncedEffectMessage;
import net.blay09.mods.cookingforblockheads.tile.CowJarBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CowJarHandler {
    private static final List<Class<? extends LivingEntity>> additionalCowClasses = Lists.newArrayList();

    public static void registerCowClass(Class<?> clazz) {
        additionalCowClasses.add(clazz);
    }

    public static void onLivingDamage(LivingDamageEvent event) {
        if (!CookingForBlockheadsConfig.getActive().cowJarEnabled) {
            return;
        }
        if (event.getDamageSource().m_19385_().equals("anvil") && CowJarHandler.isCow(event.getEntity())) {
            LivingEntity entity = event.getEntity();
            Level level = entity.m_9236_();
            CowJarHandler.findMilkJar(level, entity.m_20183_()).ifPresent(arg_0 -> CowJarHandler.lambda$onLivingDamage$0(level, (Entity)entity, event, arg_0));
        }
    }

    private static Optional<BlockPos> findMilkJar(Level level, BlockPos pos) {
        if (level.m_8055_(pos).m_60713_(ModBlocks.milkJar)) {
            return Optional.of(pos);
        }
        BlockPos posBelow = pos.m_7495_();
        if (level.m_8055_(posBelow).m_60713_(ModBlocks.milkJar)) {
            return Optional.of(posBelow);
        }
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    mutablePos.m_122154_((Vec3i)pos, x, y, z);
                    if (!level.m_8055_((BlockPos)mutablePos).m_60713_(ModBlocks.milkJar)) continue;
                    return Optional.of(mutablePos.m_7949_());
                }
            }
        }
        return Optional.empty();
    }

    public static boolean isCow(LivingEntity entity) {
        if (entity instanceof Cow) {
            return true;
        }
        for (Class<? extends LivingEntity> clazz : additionalCowClasses) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        ResourceLocation registryName = Balm.getRegistries().getKey(entity.m_6095_());
        return registryName != null && registryName.m_135815_().contains("cow");
    }

    private static /* synthetic */ void lambda$onLivingDamage$0(Level level, Entity entity, LivingDamageEvent event, BlockPos pos) {
        boolean wasCompressed;
        level.m_46597_(pos, ModBlocks.cowJar.m_49966_());
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CowJarBlockEntity && entity.m_7770_() != null) {
            MutableComponent textComponent = Component.m_237110_((String)"container.cookingforblockheads.cow_jar_custom", (Object[])new Object[]{entity.m_7770_()});
            ((CowJarBlockEntity)tileEntity).setCustomName((Component)textComponent);
        }
        if ((wasCompressed = Balm.getHooks().getPersistentData((Entity)event.getEntity()).m_128469_("excompressum").m_128471_("Compressed")) && tileEntity instanceof CowJarBlockEntity) {
            ((CowJarBlockEntity)tileEntity).setCompressedCow(true);
        }
        Balm.getNetworking().sendToTracking(entity, (Object)new SyncedEffectMessage(pos, SyncedEffectMessage.Type.COW_IN_A_JAR));
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
        event.setCanceled(true);
    }
}

