/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry.recipe;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public abstract class FoodRecipe {
    protected List<FoodIngredient> craftMatrix;
    protected ItemStack outputItem;
    protected int recipeWidth = 3;

    public List<FoodIngredient> getCraftMatrix() {
        return this.craftMatrix;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public FoodRecipeType getType() {
        return FoodRecipeType.CRAFTING;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return Balm.getRegistries().getKey(this.outputItem.m_41720_());
    }

    public void fillCraftMatrix(Recipe<?> recipe) {
        this.craftMatrix = Lists.newArrayList();
        for (Ingredient ingredient : recipe.m_7527_()) {
            if (ingredient != Ingredient.f_43901_) {
                boolean isToolItem = CookingRegistry.isToolItem(ingredient);
                this.craftMatrix.add(new FoodIngredient(ingredient, isToolItem));
                continue;
            }
            this.craftMatrix.add(null);
        }
    }
}

