/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.advancement.modification.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierSerializers;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.AdvancementModifier;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public record EffectsChangedModifier(String criteria, boolean removes, MobEffectsPredicate mobEffectsPredicate) implements AdvancementModifier<EffectsChangedModifier>
{
    private static final Field INSTANCE_EFFECTS_FIELD = ObfuscationReflectionHelper.findField(EffectsChangedTrigger.TriggerInstance.class, (String)"f_26774_");
    private static final Field PREDICATE_EFFECTS_FIELD = ObfuscationReflectionHelper.findField(MobEffectsPredicate.class, (String)"f_56548_");

    @Override
    public void modify(Advancement.Builder builder) {
        block6: {
            String criteriaKey = this.criteria;
            Criterion criterion = (Criterion)builder.m_138405_().get(criteriaKey);
            if (criterion != null) {
                CriterionTriggerInstance instance = criterion.m_11416_();
                if (instance instanceof EffectsChangedTrigger.TriggerInstance) {
                    try {
                        Map effectMap = (Map)PREDICATE_EFFECTS_FIELD.get(INSTANCE_EFFECTS_FIELD.get(instance));
                        Map configEffectMap = (Map)PREDICATE_EFFECTS_FIELD.get(this.mobEffectsPredicate);
                        if (this.removes) {
                            configEffectMap.forEach((effect, instancePredicate) -> effectMap.remove(effect));
                            break block6;
                        }
                        effectMap.putAll(configEffectMap);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                throw new IllegalArgumentException("Unknown criteria: " + criteriaKey);
            }
        }
    }

    public Serializer getSerializer() {
        return AdvancementModifierSerializers.EFFECTS_CHANGED;
    }

    public static final class Serializer
    implements AdvancementModifier.Serializer<EffectsChangedModifier> {
        @Override
        public JsonElement serialize(EffectsChangedModifier modifier, Void additional) throws JsonParseException {
            JsonObject object = new JsonObject();
            object.addProperty("criteria", modifier.criteria);
            object.addProperty("removes", Boolean.valueOf(modifier.removes));
            object.add("effects", modifier.mobEffectsPredicate.m_56565_());
            return object;
        }

        @Override
        public EffectsChangedModifier deserialize(JsonElement element, DeserializationContext additional) throws JsonParseException {
            JsonObject object = element.getAsJsonObject();
            String criteria = GsonHelper.m_13906_((JsonObject)object, (String)"criteria");
            boolean removes = GsonHelper.m_13912_((JsonObject)object, (String)"removes");
            MobEffectsPredicate effectsPredicate = MobEffectsPredicate.m_56559_((JsonElement)object.get("effects"));
            return new EffectsChangedModifier(criteria, removes, effectsPredicate);
        }
    }
}

