/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.blueprint.common.remolder.Remold;
import com.teamabnormals.blueprint.common.remolder.data.DataAccessor;
import com.teamabnormals.blueprint.common.remolder.data.DataExpressionParser;
import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.Molding;
import java.text.ParseException;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DynamicReference {
    public static final Codec<Direct> DIRECT_CODEC = new Codec<Direct>(){

        public <T> DataResult<Pair<Direct, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)Pair.of((Object)new Direct(dynamicOps -> ops.convertTo(dynamicOps, input)), (Object)ops.empty()));
        }

        public <T> DataResult<T> encode(Direct direct, DynamicOps<T> ops, T prefix) {
            return DataResult.success(direct.getter.apply(ops));
        }
    };
    public static final Codec<Expression> EXPRESSION_CODEC = Codec.STRING.flatXmap(string -> {
        try {
            return DataResult.success((Object)DynamicReference.eval(string));
        }
        catch (ParseException exception) {
            return DataResult.error(exception::getMessage);
        }
    }, expression -> DataResult.success((Object)expression.getRawExpression()));
    public static final MapCodec<DynamicReference> MAP_CODEC = Codec.mapEither((MapCodec)DIRECT_CODEC.fieldOf("value"), (MapCodec)EXPRESSION_CODEC.fieldOf("expressed_value")).xmap(either -> {
        Optional left = either.left();
        if (left.isPresent()) {
            return (DynamicReference)left.get();
        }
        return (DynamicReference)either.right().get();
    }, reference -> {
        if (reference instanceof Direct) {
            Direct direct = (Direct)reference;
            return Either.left((Object)direct);
        }
        return Either.right((Object)((Expression)reference));
    });

    public static Direct value(Function<DynamicOps<?>, ?> getter) {
        return new Direct(getter);
    }

    public static <A> Direct value(A value, Encoder<A> encoder) {
        return new Direct(dynamicOps -> {
            DataResult dataResult = encoder.encodeStart(dynamicOps, value);
            Optional error = dataResult.error();
            if (error.isPresent()) {
                throw new RuntimeException(((DataResult.PartialResult)error.get()).message());
            }
            return dataResult.result().get();
        });
    }

    public static <A> Direct value(A value, final Function<A, JsonElement> encoder) {
        return DynamicReference.value(value, new Encoder<A>(){

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, (JsonElement)encoder.apply(input)));
            }
        });
    }

    public static Expression target(String expression) {
        return new Expression(expression, null);
    }

    public static Expression eval(String expression) throws ParseException {
        return new Expression(expression);
    }

    public DataAccessor access();

    public static final class Direct
    implements DynamicReference {
        private final Function<DynamicOps<?>, ?> getter;
        private final DataAccessor dataAccessor;

        public Direct(final Function<DynamicOps<?>, ?> getter) {
            this.getter = getter;
            final String fieldName = "getter" + System.nanoTime();
            this.dataAccessor = new DataAccessor(){

                @Override
                public void visitParent(Molding<?> molding, String owner, MethodVisitor method) {
                }

                @Override
                public void visitIdentifier(Molding<?> molding, String owner, MethodVisitor method) {
                }

                @Override
                public boolean isIdentifierAnIndex() {
                    return false;
                }

                @Override
                public void visit(Molding<?> molding, String owner, MethodVisitor method) {
                    method.visitVarInsn(25, 0);
                    method.visitFieldInsn(180, owner, fieldName, "Ljava/util/function/Function;");
                    method.visitVarInsn(25, 1);
                    method.visitMethodInsn(185, "java/util/function/Function", "apply", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                    molding.cast(method);
                }

                @Override
                public void accept(Remold.Fields fields) {
                    fields.addField(fieldName, new Remold.Field(() -> getter, "java/util/function/Function", "Ljava/util/function/Function;", (molding, methodVisitor) -> {}));
                }

                @Override
                public DataType getDataType() {
                    return DataType.ELEMENT;
                }
            };
        }

        @Override
        public DataAccessor access() {
            return this.dataAccessor;
        }
    }

    public static final class Expression
    implements DynamicReference {
        private final String rawExpression;
        private final DataAccessor accessor;

        public Expression(String rawExpression) throws ParseException {
            this(rawExpression, DataExpressionParser.parse(rawExpression));
        }

        public Expression(String rawExpression, @Nullable DataAccessor accessor) {
            this.rawExpression = rawExpression;
            this.accessor = accessor;
        }

        public String getRawExpression() {
            return this.rawExpression;
        }

        @Override
        public DataAccessor access() {
            return this.accessor;
        }
    }
}

