/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import de.ellpeck.naturesaura.reg.ModTileType;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class BlockContainerImpl
extends BaseEntityBlock
implements IModItem {
    private final String baseName;
    private final Class<? extends BlockEntity> tileClass;
    private final ModTileType<? extends BlockEntity> tileType;

    public BlockContainerImpl(String baseName, Class<? extends BlockEntity> tileClass, BlockBehaviour.Properties properties) {
        super(properties);
        this.baseName = baseName;
        this.tileClass = tileClass;
        this.tileType = new ModTileType(this::createBlockEntity, this);
        ModRegistry.ALL_ITEMS.add(this);
        ModRegistry.ALL_ITEMS.add(this.tileType);
        if (this.hasWaterlogging()) {
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected boolean hasWaterlogging() {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.hasWaterlogging()) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        }
    }

    public FluidState m_5888_(BlockState state) {
        return this.hasWaterlogging() && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.hasWaterlogging() && ((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            levelIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelIn));
        }
        return super.m_7417_(stateIn, facing, facingState, levelIn, currentPos, facingPos);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (this.hasWaterlogging()) {
            FluidState state = context.m_43725_().m_6425_(context.m_8083_());
            return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_205070_(FluidTags.f_13131_) && state.m_76186_() == 8));
        }
        return super.m_5573_(context);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.createBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (ITickableBlockEntity.class.isAssignableFrom(this.tileClass)) {
            return ITickableBlockEntity.createTickerHelper(type, this.tileType.type);
        }
        return null;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        BlockEntity tile = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (tile instanceof BlockEntityImpl) {
            for (ItemStack stack : drops) {
                if (stack.m_41720_() != this.m_5456_()) continue;
                ((BlockEntityImpl)tile).modifyDrop(stack);
                break;
            }
        }
        return drops;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof BlockEntityImpl) {
            BlockEntityImpl impl = (BlockEntityImpl)tile;
            impl.dropInventory();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level levelIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tile = levelIn.m_7702_(pos);
        if (tile instanceof BlockEntityImpl) {
            ((BlockEntityImpl)tile).loadDataOnPlace(stack);
        }
    }

    public void m_6861_(BlockState state, Level levelIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateRedstoneState(levelIn, pos);
    }

    private void updateRedstoneState(Level level, BlockPos pos) {
        BlockEntity tile;
        if (!level.f_46443_ && (tile = level.m_7702_(pos)) instanceof BlockEntityImpl) {
            BlockEntityImpl impl = (BlockEntityImpl)tile;
            int newPower = level.m_277086_(pos);
            if (impl.redstonePower != newPower) {
                level.m_186460_(pos, (Block)this, 4);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel levelIn, BlockPos pos, RandomSource random) {
        BlockEntity tile;
        if (!levelIn.f_46443_ && (tile = levelIn.m_7702_(pos)) instanceof BlockEntityImpl) {
            BlockEntityImpl impl = (BlockEntityImpl)tile;
            int newPower = levelIn.m_277086_(pos);
            if (impl.redstonePower != newPower) {
                impl.onRedstonePowerChange(newPower);
            }
        }
    }

    private BlockEntity createBlockEntity(BlockPos pos, BlockState state) {
        try {
            return this.tileClass.getConstructor(BlockPos.class, BlockState.class).newInstance(pos, state);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot construct block entity from class " + this.tileClass, e);
        }
    }
}

