/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.tuple.Pair;

public class NetherDecayEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "nether_decay");
    private int amount;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot >= 0) {
            return false;
        }
        Pair<Integer, Integer> auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 50);
        int aura = (Integer)auraAndSpots.getLeft();
        if (aura >= 0) {
            return false;
        }
        this.amount = Math.min(300, Mth.m_14167_((float)((float)Math.abs(aura) / 50000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
        if (this.amount <= 1) {
            return false;
        }
        this.dist = Mth.m_14045_((int)(Math.abs(aura) / 50000), (int)5, (int)75);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.m_9236_(), pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)Items.f_42049_);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, AuraChunk.DrainSpot actualSpot) {
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + level.f_46441_.m_188503_(this.amount / 2); i >= 0; --i) {
            BlockPos offset = BlockPos.m_274561_((double)((double)pos.m_123341_() + level.f_46441_.m_188583_() * (double)this.dist), (double)((double)pos.m_123342_() + level.f_46441_.m_188583_() * (double)this.dist), (double)((double)pos.m_123343_() + level.f_46441_.m_188583_() * (double)this.dist));
            if (offset.m_123331_((Vec3i)pos) > (double)(this.dist * this.dist) || !level.m_46749_(offset)) continue;
            Block degraded = null;
            BlockState state = level.m_8055_(offset);
            if (state.m_60734_() == Blocks.f_50141_) {
                degraded = Blocks.f_50134_;
            } else if (state.m_204336_(BlockTags.f_13077_) || state.m_60734_() == Blocks.f_50134_) {
                degraded = Blocks.f_50136_;
            } else if (state.m_60734_() == Blocks.f_50136_) {
                degraded = Blocks.f_50135_;
            }
            if (degraded != null) {
                level.m_46796_(2001, offset, Block.m_49956_((BlockState)state));
                level.m_46597_(offset, degraded.m_49966_());
            }
            if (!BaseFireBlock.m_49255_((Level)level, (BlockPos)offset, (Direction)Direction.NORTH)) continue;
            BlockState fire = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)offset);
            level.m_46597_(offset, fire);
            level.m_46796_(1009, offset, 0);
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.netherDecayEffect.get() != false && type.isSimilar(NaturesAuraAPI.TYPE_NETHER);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

