/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.ebintegration.mixin;

import it.mralxart.ebintegration.tiles.EtherbloomTile;
import it.mralxart.ebintegration.utils.BlockUtils;
import it.mralxart.etheria.items.base.IEtherEntryItem;
import it.mralxart.etheria.tiles.EtherDistributorTile;
import it.mralxart.etheria.utils.EtherUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EtherDistributorTile.class})
public class EtherDistributorTileMixin {
    @Unique
    private Queue<BlockPos> ebintegration$flowerQueue = new LinkedList<BlockPos>();
    @Unique
    private BlockPos ebintegration$currentFlowerPos = null;

    @Inject(method={"tick*"}, at={@At(value="TAIL")}, remap=false)
    public void onTick(Level level, BlockPos pos, BlockState blockState, CallbackInfo ci) {
        EtherDistributorTile tile = (EtherDistributorTile)this;
        if (this.ebintegration$flowerQueue.isEmpty() || level.m_46467_() % 20L == 0L) {
            List<BlockPos> flowerPositions = BlockUtils.findBlockEntities(level, tile.m_58899_(), 2, EtherbloomTile.class);
            ArrayList<BlockPos> immutablePositions = new ArrayList<BlockPos>();
            for (BlockPos p : flowerPositions) {
                immutablePositions.add(p.m_7949_());
            }
            this.ebintegration$flowerQueue.clear();
            this.ebintegration$flowerQueue.addAll(immutablePositions);
        }
        if (this.ebintegration$currentFlowerPos == null && !this.ebintegration$flowerQueue.isEmpty()) {
            this.ebintegration$currentFlowerPos = this.ebintegration$flowerQueue.poll();
        }
        if (this.ebintegration$currentFlowerPos != null) {
            BlockEntity blockEntity = level.m_7702_(this.ebintegration$currentFlowerPos);
            boolean isValidFlower = false;
            if (blockEntity instanceof EtherbloomTile) {
                EtherbloomTile etherbloomTile = (EtherbloomTile)blockEntity;
                isValidFlower = true;
                if (etherbloomTile.workTime > 0) {
                    BlockPos posCap = this.ebintegration$currentFlowerPos;
                    this.ebintegration$currentFlowerPos = this.ebintegration$flowerQueue.poll();
                    this.ebintegration$flowerQueue.add(posCap);
                } else {
                    this.ebintegration$tickAnimation(level, tile, this.ebintegration$currentFlowerPos);
                }
            }
            if (!isValidFlower) {
                this.ebintegration$currentFlowerPos = null;
            }
        }
    }

    @Unique
    private void ebintegration$tickAnimation(Level level, EtherDistributorTile tile, BlockPos flowerPos) {
        BlockEntity blockEntity = level.m_7702_(flowerPos);
        if (blockEntity instanceof EtherbloomTile) {
            int itemEther;
            EtherbloomTile etherbloomTile = (EtherbloomTile)blockEntity;
            if (etherbloomTile.workTime > 0) {
                BlockPos pos = this.ebintegration$currentFlowerPos;
                this.ebintegration$currentFlowerPos = this.ebintegration$flowerQueue.poll();
                this.ebintegration$flowerQueue.add(pos);
                return;
            }
            ItemStack itemStack = tile.getItemStack();
            if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof IEtherEntryItem && (itemEther = EtherUtils.getEther((ItemStack)itemStack)) >= 5) {
                int maxTime = this.ebintegration$calculateMaxTime(this.ebintegration$flowerQueue.size());
                Runnable runnable = () -> {
                    EtherUtils.setEther((ItemStack)itemStack, (int)(itemEther - 5));
                    etherbloomTile.workTime = 1200;
                    BlockPos pos = this.ebintegration$currentFlowerPos;
                    this.ebintegration$currentFlowerPos = this.ebintegration$flowerQueue.poll();
                    this.ebintegration$flowerQueue.add(pos);
                };
                VoxelShape shape = level.m_8055_(flowerPos).m_60808_((BlockGetter)level, flowerPos);
                if (!shape.m_83281_()) {
                    AABB boundingBox = shape.m_83215_();
                    double offsetX = boundingBox.f_82288_ + (boundingBox.f_82291_ - boundingBox.f_82288_) / 2.0;
                    double offsetZ = boundingBox.f_82290_ + (boundingBox.f_82293_ - boundingBox.f_82290_) / 2.0;
                    Vec3 posCenter = flowerPos.m_252807_().m_82520_(offsetX - 0.5, 0.15, offsetZ - 0.5);
                    Vec3 posRes = tile.m_58899_().m_252807_().m_82520_(0.0, 0.5, 0.0);
                    ParticleUtils.createLines((Level)level, (Vec3)posCenter, (Vec3)posRes, etherbloomTile.lines, (Runnable)runnable, (float)0.0f, (float)0.3f, (int)maxTime, (int)30, (boolean)false);
                }
            }
        }
    }

    @Unique
    private int ebintegration$calculateMaxTime(int flowerCount) {
        if (flowerCount <= 14) {
            return 60 - flowerCount * 2;
        }
        return 40;
    }
}

