/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.ebintegration.tiles;

import it.mralxart.ebintegration.registry.TileRegistry;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;

public class EtherbloomTile
extends GeneratingFlowerBlockEntity
implements WandHUD,
WandBindable,
Wandable {
    public int workTime = 0;
    private static final int RANGE = 2;
    public List<ParticleUtils.LineData> lines = new ArrayList<ParticleUtils.LineData>(1);

    public EtherbloomTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ETHERBLOOM.get(), pos, state);
        this.lines.add(new ParticleUtils.LineData(16));
    }

    public void tickFlower() {
        VoxelShape shape;
        super.tickFlower();
        if (this.workTime > 0) {
            --this.workTime;
        }
        if (this.f_58857_ != null && this.workTime > 0 && this.ticksExisted % 5 == 0 && !(shape = this.f_58857_.m_8055_(this.m_58899_()).m_60808_((BlockGetter)this.f_58857_, this.m_58899_())).m_83281_()) {
            AABB boundingBox = shape.m_83215_();
            double offsetX = boundingBox.f_82288_ + (boundingBox.f_82291_ - boundingBox.f_82288_) * this.f_58857_.f_46441_.m_188500_();
            double offsetY = boundingBox.f_82289_ + (boundingBox.f_82292_ - boundingBox.f_82289_) * this.f_58857_.f_46441_.m_188500_();
            double offsetZ = boundingBox.f_82290_ + (boundingBox.f_82293_ - boundingBox.f_82290_) * this.f_58857_.f_46441_.m_188500_();
            Networking.sendToAll((Object)new ParticleSpawnerPacket((ParticleOptions)new GlowingParticleData(ElementsUtils.getRandomColorByElement((Element)Element.ETHER).getRGB(), Math.max(0.1f, this.f_58857_.f_46441_.m_188501_() / 4.0f), 20 + this.f_58857_.f_46441_.m_216339_(3, 30), 0.1f, 1.0f), (double)this.m_58899_().m_123341_() + offsetX, (double)this.m_58899_().m_123342_() + offsetY + (double)0.2f, (double)this.m_58899_().m_123343_() + offsetZ, 0.0, (double)0.02f * (offsetY + 0.7) / 2.0, 0.0));
        }
        if (this.workTime > 0 && this.ticksExisted % 2 == 0) {
            this.addMana(2);
        }
    }

    public boolean m_7531_(int event, int param) {
        if (event == 0) {
            Entity e = this.m_58904_().m_6815_(param);
            if (e != null) {
                e.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, e.m_20185_(), e.m_20186_() + 0.1, e.m_20189_(), 0.0, 0.0, 0.0);
                e.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, e.m_20185_(), e.m_20186_(), e.m_20189_(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        return super.m_7531_(event, param);
    }

    public int getMaxMana() {
        return 300;
    }

    public int getColor() {
        return 13603561;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)2);
    }

    private int getBurnTime(ItemStack stack) {
        if (stack.m_41619_() || Block.m_49814_((Item)stack.m_41720_()) instanceof ManaSpreaderBlock) {
            return 0;
        }
        if (stack.m_41720_() == ItemRegistry.ETHER_SHARD.get()) {
            return 10;
        }
        return 0;
    }

    public ItemStack getHudIcon() {
        EtherbloomTile boundTile = (EtherbloomTile)((Object)this.findBoundTile());
        if (boundTile != null) {
            return new ItemStack((ItemLike)boundTile.m_58900_().m_60734_().m_5456_());
        }
        return this.getDefaultHudIcon();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaForgeCapabilities.WANDABLE) {
            return LazyOptional.of(() -> this).cast();
        }
        return (LazyOptional)DistExecutor.unsafeRunForDist(() -> () -> cap == BotaniaForgeClientCapabilities.WAND_HUD ? LazyOptional.of(() -> this).cast() : super.getCapability(cap, side), () -> () -> super.getCapability(cap, side));
    }

    public void renderHUD(GuiGraphics guiGraphics, Minecraft minecraft) {
        if (this.f_58857_ == null) {
            return;
        }
        String name = I18n.m_118938_((String)this.m_58900_().m_60734_().m_7705_(), (Object[])new Object[0]);
        int centerX = minecraft.m_91268_().m_85445_() / 2;
        int centerY = minecraft.m_91268_().m_85446_() / 2;
        int left = (Math.max(102, minecraft.f_91062_.m_92895_(name)) + 4) / 2;
        int right = left + 20;
        RenderHelper.renderHUDBox((GuiGraphics)guiGraphics, (int)(centerX - left), (int)(centerY + 8), (int)(centerX + right), (int)(centerY + 30));
        BotaniaAPIClient.instance().drawComplexManaHUD(guiGraphics, this.getColor(), this.getMana(), this.getMaxMana(), name, new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", "mana_spreader")))), this.isValidBinding());
    }

    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        return true;
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.workTime = cmp.m_128451_("workTime");
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_("workTime", this.workTime);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof EtherbloomTile) {
            EtherbloomTile tile = (EtherbloomTile)t;
            tile.setFloating(true);
            SpecialFlowerBlockEntity.commonTick((Level)level, (BlockPos)pos, (BlockState)blockState, (SpecialFlowerBlockEntity)tile);
        }
    }
}

