/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.ArrayUtils;

public class DirectionSelector {
    private static final Direction[] ALL = (Direction[])ArrayUtils.addAll((Object[])Direction.values(), (Object[])new Direction[]{null});
    private Direction direction;
    private boolean modified;
    private final ItemStack stack;
    private final PipeBlockEntity pipe;

    public DirectionSelector(ItemStack stack, PipeBlockEntity pipe) {
        this.stack = stack;
        this.pipe = pipe;
        this.load();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractWidget getButton(int x, int y) {
        return new ExtendedButton(x, y, 100, 20, (Component)Component.m_237115_((String)"info.prettypipes.populate"), button -> PacketButton.sendAndExecute(this.pipe.m_58899_(), PacketButton.ButtonResult.DIRECTION_SELECTOR, new int[0])){

            public Component m_6035_() {
                PipeBlockEntity pipe = DirectionSelector.this.pipe;
                Direction dir = DirectionSelector.this.direction;
                MutableComponent msg = Component.m_237115_((String)("dir.prettypipes." + (dir != null ? dir.m_122433_() : "all")));
                if (dir != null) {
                    MutableComponent blockName;
                    MutableComponent mutableComponent = blockName = pipe.getItemHandler(dir) != null ? pipe.m_58904_().m_8055_(pipe.m_58899_().m_121945_(dir)).m_60734_().m_49954_() : null;
                    if (blockName != null) {
                        msg = msg.m_130946_(" (").m_7220_((Component)blockName).m_130946_(")");
                    }
                }
                return msg;
            }
        };
    }

    public void onButtonPacket() {
        Direction dir = this.direction;
        while (!this.isDirectionValid(dir = ALL[(ArrayUtils.indexOf((Object[])ALL, (Object)dir) + 1) % ALL.length])) {
        }
        if (this.direction != dir) {
            this.direction = dir;
            this.modified = true;
        }
    }

    public void save() {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        CompoundTag tag = new CompoundTag();
        if (this.direction != null) {
            tag.m_128359_("direction", this.direction.m_122433_());
        }
        this.stack.m_41784_().m_128365_("direction_selector", (Tag)tag);
    }

    public void load() {
        if (this.stack.m_41782_()) {
            CompoundTag tag = this.stack.m_41783_().m_128469_("direction_selector");
            this.direction = Direction.m_122402_((String)tag.m_128461_("direction"));
        }
    }

    public Direction[] directions() {
        Direction[] directionArray;
        if (this.direction != null) {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = this.direction;
        } else {
            directionArray = Direction.values();
        }
        return directionArray;
    }

    public boolean has(Direction dir) {
        return this.direction == null || this.direction == dir;
    }

    private boolean isDirectionValid(Direction dir) {
        if (dir == null) {
            return true;
        }
        if (this.pipe.getItemHandler(dir) == null) {
            return false;
        }
        return this.pipe.streamModules().filter(p -> p.getLeft() != this.stack).map(p -> ((IModule)p.getRight()).getDirectionSelector((ItemStack)p.getLeft(), this.pipe)).noneMatch(p -> p != null && p.direction == dir);
    }

    public static interface IDirectionContainer {
        public DirectionSelector getSelector();
    }
}

