/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.network.packet;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.api.ZombieApi;
import com.faboslav.variantsandventures.common.network.MessageHandler;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Zombie;

public record SyncZombieIsShakingPacketFromServer(int zombieId, boolean isShaking) implements Packet<SyncZombieIsShakingPacketFromServer>
{
    public static final ResourceLocation ID = VariantsAndVentures.makeID("sync_horse_owner_uuid_from_server");
    public static final ClientboundPacketType<SyncZombieIsShakingPacketFromServer> TYPE = new Handler();

    public static void sendToClient(Entity entity, int zombieId, boolean isShaking) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayersInLevel((Packet)new SyncZombieIsShakingPacketFromServer(zombieId, isShaking), entity.m_9236_());
    }

    public PacketType<SyncZombieIsShakingPacketFromServer> type() {
        return TYPE;
    }

    private static final class Handler
    implements ClientboundPacketType<SyncZombieIsShakingPacketFromServer> {
        private Handler() {
        }

        public void encode(SyncZombieIsShakingPacketFromServer message, FriendlyByteBuf buffer) {
            buffer.m_130130_(message.zombieId());
            buffer.writeBoolean(message.isShaking());
        }

        public SyncZombieIsShakingPacketFromServer decode(FriendlyByteBuf buffer) {
            return new SyncZombieIsShakingPacketFromServer(buffer.m_130242_(), buffer.readBoolean());
        }

        public Runnable handle(SyncZombieIsShakingPacketFromServer packet) {
            return () -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.zombieId());
                if (entity instanceof Zombie) {
                    Zombie zombie = (Zombie)entity;
                    ((ZombieApi)zombie).variantsandventures$setFreezeConverting(packet.isShaking());
                }
            };
        }

        public Class<SyncZombieIsShakingPacketFromServer> type() {
            return SyncZombieIsShakingPacketFromServer.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

