/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.dim;

import com.lothrazar.library.core.BlockPosDim;
import com.lothrazar.library.util.LevelWorldUtil;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class DimensionTransit
implements ITeleporter {
    protected ServerLevel world;
    private BlockPosDim target;

    public DimensionTransit(ServerLevel world, BlockPosDim target) {
        this.world = world;
        this.target = target;
    }

    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        BlockPos myPos = this.moveToSafeCoords(destWorld, this.target.getPos());
        return new PortalInfo(new Vec3((double)((float)myPos.m_123341_() + 0.5f), (double)((float)myPos.m_123342_() + 0.5f), (double)((float)myPos.m_123343_() + 0.5f)), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    private BlockPos moveToSafeCoords(ServerLevel world, BlockPos pos) {
        for (int tries = 10; tries > 0; --tries) {
            if (!world.m_8055_(pos).m_280296_()) continue;
            pos = pos.m_7494_();
        }
        return pos;
    }

    public Entity placeEntity(Entity newEntity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        if (newEntity instanceof LivingEntity) {
            ((LivingEntity)newEntity).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 200, false, false));
            ((LivingEntity)newEntity).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 20, false, false));
        }
        newEntity.f_19789_ = 0.0f;
        return repositionEntity.apply(false);
    }

    public void teleport(Player player) {
        if (!player.m_7500_() && !player.m_9236_().f_46443_) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 200, false, false));
        }
        if (this.world != null) {
            this.world.m_6263_(player, (double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, SoundEvents.f_12287_, SoundSource.MASTER, 0.25f, this.world.f_46441_.m_188501_() * 0.4f + 0.8f);
        }
    }

    public ServerLevel getTargetLevel() {
        return this.world == null ? null : this.world.m_7654_().m_129880_(LevelWorldUtil.stringToDimension(this.target.getDimension()));
    }
}

