/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundUtil {
    public static void playSoundAtBlock(Level world, Entity player, BlockPos pos, SoundEvent soundIn) {
        world.m_245803_(player, pos, soundIn, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void playSound(Level world, BlockPos pos, SoundEvent soundIn) {
        world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundIn, SoundSource.BLOCKS, 0.5f, 0.5f, false);
    }

    public static void playSound(Level world, BlockPos pos, SoundEvent soundIn, float volume) {
        world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundIn, SoundSource.BLOCKS, volume, 0.5f, false);
    }

    public static void playSound(Entity entityIn, SoundEvent soundIn) {
        SoundUtil.playSound(entityIn, soundIn, 1.0f, 1.0f);
    }

    public static void playSound(Entity entityIn, SoundEvent soundIn, float volume) {
        SoundUtil.playSound(entityIn, soundIn, volume, 1.0f);
    }

    public static void playSound(Entity entityIn, SoundEvent soundIn, float volume, float pitch) {
        if (entityIn != null && entityIn.m_9236_().f_46443_) {
            entityIn.m_5496_(soundIn, volume, pitch);
        }
    }

    public static void playSoundFromServer(ServerPlayer entityIn, BlockPos pos, SoundEvent soundIn, float vol, float pitch) {
        if (soundIn == null || entityIn == null) {
            return;
        }
        entityIn.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)soundIn), SoundSource.BLOCKS, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), vol, pitch, entityIn.m_9236_().m_213780_().m_188505_()));
    }

    public static void playSoundFromServer(ServerPlayer entityIn, SoundEvent soundIn, float vol, float pitch) {
        if (soundIn == null || entityIn == null) {
            return;
        }
        entityIn.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)soundIn), SoundSource.BLOCKS, entityIn.f_19790_, entityIn.f_19791_, entityIn.f_19792_, vol, pitch, entityIn.m_9236_().m_213780_().m_188505_()));
    }

    public static void playSoundFromServer(ServerLevel world, BlockPos pos, SoundEvent soundIn) {
        for (ServerPlayer sp : world.m_6907_()) {
            SoundUtil.playSoundFromServer(sp, pos, soundIn, 1.0f, 1.0f);
        }
    }

    public static void playSoundFromServerById(ServerLevel world, BlockPos pos, String sid) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(sid));
        if (sound != null) {
            for (ServerPlayer sp : world.m_6907_()) {
                SoundUtil.playSoundFromServer(sp, pos, sound, 1.0f, 1.0f);
            }
        }
    }

    public static void playSoundById(Player player, String sid) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(sid));
        if (sound != null && player.m_9236_().f_46443_) {
            SoundUtil.playSound((Entity)player, sound);
        }
    }
}

