/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.loading.ClientModLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.resource.DelegatingPackResources;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourcePackLoader;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.LoadingContext;
import snownee.kiwi.customization.CustomizationClient;
import snownee.kiwi.customization.CustomizationMetadata;
import snownee.kiwi.customization.CustomizationRegistries;
import snownee.kiwi.customization.CustomizationServiceFinder;
import snownee.kiwi.customization.KiwiPackResourceManager;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.block.GlassType;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;
import snownee.kiwi.customization.block.behavior.SitManager;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.BuilderRules;
import snownee.kiwi.customization.item.ItemFundamentals;
import snownee.kiwi.customization.item.loader.KCreativeTab;
import snownee.kiwi.customization.item.loader.KItemTemplate;
import snownee.kiwi.customization.placement.PlacementSystem;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.ClientProxy;
import snownee.kiwi.util.resource.OneTimeLoader;
import snownee.kiwi.util.resource.RequiredFolderRepositorySource;

public final class CustomizationHooks {
    private static final Set<String> blockNamespaces = Sets.newLinkedHashSet();
    private static final Set<String> lenientBETypeNamespaces = Sets.newHashSet();
    private static boolean enabled = true;
    public static boolean kswitch = Platform.isModLoaded("kswitch") || !Platform.isProduction();
    @Nullable
    private static GlassType clearGlassType;
    private static final int CACHE_SIZE = 512;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> OCCLUSION_CACHE;

    private CustomizationHooks() {
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean skipGlassRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        if (KBlockSettings.of(pState.m_60734_()) == null && KBlockSettings.of(pAdjacentBlockState.m_60734_()) == null) {
            return false;
        }
        GlassType glassType = CustomizationHooks.getGlassType(pState);
        if (glassType == null || !glassType.skipRendering()) {
            return false;
        }
        if (!pState.m_60713_(pAdjacentBlockState.m_60734_()) && glassType != CustomizationHooks.getGlassType(pAdjacentBlockState)) {
            return false;
        }
        Block.BlockStatePairKey key = new Block.BlockStatePairKey(pState, pAdjacentBlockState, pDirection);
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> map = OCCLUSION_CACHE.get();
        byte b0 = map.getAndMoveToFirst((Object)key);
        if (b0 != 127) {
            return b0 == 0;
        }
        VoxelShape shape1 = KBlockSettings.getGlassFaceShape(pState, pDirection);
        if (shape1.m_83281_()) {
            return true;
        }
        VoxelShape shape2 = KBlockSettings.getGlassFaceShape(pAdjacentBlockState, pDirection.m_122424_());
        boolean flag = Shapes.m_83157_((VoxelShape)shape1, (VoxelShape)shape2, (BooleanOp)BooleanOp.f_82685_);
        if (map.size() == 512) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst((Object)key, (byte)(flag ? 1 : 0));
        return !flag;
    }

    @Nullable
    public static GlassType getGlassType(BlockState blockState) {
        KBlockSettings settings = KBlockSettings.of(blockState.m_60734_());
        if (settings != null && settings.glassType != null) {
            return settings.glassType;
        }
        if (CustomizationHooks.isColorlessGlass(blockState)) {
            return clearGlassType;
        }
        return null;
    }

    public static void init() {
        enabled = CustomizationServiceFinder.shouldEnable(ModList.get().getMods());
        if (!CustomizationHooks.isEnabled()) {
            return;
        }
        Kiwi.LOGGER.info("Kiwi Customization is enabled");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(EventPriority.LOWEST, event -> {
            if (!Registries.f_256747_.equals((Object)event.getRegistryKey())) {
                return;
            }
            CustomizationHooks.initLoader(modEventBus);
        });
        modEventBus.addListener(event -> {
            event.create(new RegistryBuilder().setName(CustomizationRegistries.BLOCK_COMPONENT_KEY.m_135782_()).disableOverrides().disableSaving().hasTags(), $ -> {
                CustomizationRegistries.BLOCK_COMPONENT = (Registry)BuiltInRegistries.f_257047_.m_7745_(CustomizationRegistries.BLOCK_COMPONENT_KEY.m_135782_());
                Kiwi.registerRegistry($, KBlockComponent.Type.class);
            });
            event.create(new RegistryBuilder().setName(CustomizationRegistries.BLOCK_TEMPLATE_KEY.m_135782_()).disableOverrides().disableSaving().hasTags(), $ -> {
                CustomizationRegistries.BLOCK_TEMPLATE = (Registry)BuiltInRegistries.f_257047_.m_7745_(CustomizationRegistries.BLOCK_TEMPLATE_KEY.m_135782_());
                Kiwi.registerRegistry($, KBlockTemplate.Type.class);
            });
            event.create(new RegistryBuilder().setName(CustomizationRegistries.ITEM_TEMPLATE_KEY.m_135782_()).disableOverrides().disableSaving().hasTags(), $ -> {
                CustomizationRegistries.ITEM_TEMPLATE = (Registry)BuiltInRegistries.f_257047_.m_7745_(CustomizationRegistries.ITEM_TEMPLATE_KEY.m_135782_());
                Kiwi.registerRegistry($, KItemTemplate.Type.class);
            });
            event.create(new RegistryBuilder().setName(CustomizationRegistries.BUILDER_RULE_KEY.m_135782_()).disableOverrides().disableSaving().hasTags(), $ -> {
                CustomizationRegistries.BUILDER_RULE = (Registry)BuiltInRegistries.f_257047_.m_7745_(CustomizationRegistries.BUILDER_RULE_KEY.m_135782_());
                Kiwi.registerRegistry($, BuilderRule.Type.class);
            });
        });
        modEventBus.addListener(event -> event.addRepositorySource((RepositorySource)new RequiredFolderRepositorySource(CustomizationServiceFinder.PACK_DIRECTORY, event.getPackType(), PackSource.f_10528_)));
        forgeEventBus.addListener(event -> {
            if (PlacementSystem.isDebugEnabled(event.getPlayer())) {
                PlacementSystem.removeDebugBlocks(event.getPlayer().m_9236_(), event.getPos());
            }
        });
        forgeEventBus.addListener(event -> {
            InteractionResult result = BlockBehaviorRegistry.getInstance().onUseBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            if (result.m_19077_()) {
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        });
        forgeEventBus.addListener(event -> {
            if (event.getHand() == InteractionHand.MAIN_HAND && SitManager.sit(event.getEntity(), event.getHitVec())) {
                event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().f_46443_));
                event.setCanceled(true);
            }
        });
        forgeEventBus.addListener(event -> {
            if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD && Platform.isPhysicalClient()) {
                return;
            }
            BlockFamilies.reloadTags();
        });
        if (Platform.isPhysicalClient()) {
            CustomizationClient.init();
        }
    }

    public static void initLoader(IEventBus modEventBus) {
        ResourceManager resourceManager = CustomizationHooks.collectKiwiPacks();
        OneTimeLoader.Context context = new OneTimeLoader.Context();
        Map<String, CustomizationMetadata> metadataMap = CustomizationMetadata.loadMap(resourceManager, context);
        BlockFundamentals blockFundamentals = BlockFundamentals.reload(resourceManager, context, true);
        clearGlassType = blockFundamentals.glassTypes().get(new ResourceLocation("clear"));
        Preconditions.checkNotNull((Object)clearGlassType, (Object)"Missing 'clear' glass type");
        blockNamespaces.clear();
        blockFundamentals.blocks().keySet().stream().map(ResourceLocation::m_135827_).forEach(blockNamespaces::add);
        lenientBETypeNamespaces.clear();
        lenientBETypeNamespaces.add("minecraft");
        lenientBETypeNamespaces.addAll(blockNamespaces);
        metadataMap.values().forEach(metadata -> lenientBETypeNamespaces.addAll(metadata.lenientBETypeNamespaces()));
        ArrayList blockIds = Lists.newArrayList();
        CustomizationMetadata.sortedForEach(metadataMap, "block", blockFundamentals.blocks(), (id, definition) -> {
            try {
                Block block = definition.createBlock((ResourceLocation)id, blockFundamentals.shapes());
                ForgeRegistries.BLOCKS.register(id, (Object)block);
                blockFundamentals.slotProviders().attachSlotsA(block, (KBlockDefinition)definition);
                blockFundamentals.placeChoices().attachChoicesA(block, (KBlockDefinition)definition);
                blockIds.add(id);
            }
            catch (Exception e) {
                Kiwi.LOGGER.error("Failed to create block %s".formatted(id), (Throwable)e);
            }
        });
        ItemFundamentals itemFundamentals = ItemFundamentals.reload(resourceManager, context, true);
        for (ResourceLocation blockId : blockIds) {
            if (itemFundamentals.items().containsKey(blockId)) continue;
            itemFundamentals.addDefaultBlockItem(blockId);
        }
        KItemTemplate none = itemFundamentals.templates().get(new ResourceLocation("none"));
        Preconditions.checkNotNull((Object)none, (Object)"Missing 'none' item definition");
        CustomizationMetadata.sortedForEach(metadataMap, List.of("item", "block"), itemFundamentals.items(), (id, definition) -> {
            try {
                if (definition.template().template() == none) {
                    return;
                }
                Item item = definition.createItem((ResourceLocation)id);
                ForgeRegistries.ITEMS.register(id, (Object)item);
            }
            catch (Exception e) {
                Kiwi.LOGGER.error("Failed to create item %s".formatted(id), (Throwable)e);
            }
        });
        blockFundamentals.slotProviders().attachSlotsB();
        blockFundamentals.placeChoices().attachChoicesB();
        blockFundamentals.slotLinks().finish();
        if (Platform.isPhysicalClient()) {
            CustomizationClient.afterRegister(itemFundamentals.items(), blockFundamentals.blocks(), new ClientProxy.Context(ClientModLoader.isLoading(), modEventBus));
        }
        Map<ResourceLocation, KCreativeTab> tabs = OneTimeLoader.load(resourceManager, "kiwi/creative_tab", KCreativeTab.CODEC, context);
        List<Map.Entry> newTabs = tabs.entrySet().stream().sorted(Comparator.comparingInt($ -> ((KCreativeTab)$.getValue()).order())).filter(entry -> {
            KCreativeTab value = (KCreativeTab)entry.getValue();
            if (value.insert().isPresent()) {
                CustomizationHooks.insertToTab(modEventBus, value);
                return false;
            }
            return true;
        }).toList();
        for (int i = 0; i < newTabs.size(); ++i) {
            Map.Entry entry2 = newTabs.get(i);
            ResourceLocation key = (ResourceLocation)entry2.getKey();
            KCreativeTab value = (KCreativeTab)entry2.getValue();
            CreativeModeTab.Builder tab = AbstractModule.itemCategory(key.m_135827_(), key.m_135815_(), () -> BuiltInRegistries.f_257033_.m_123009_(value.icon()).orElse(Items.f_42127_).m_7968_()).m_257501_((params, output) -> output.m_246601_(value.contents().stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_6246_(arg_0)).filter(Objects::nonNull).map(Item::m_7968_).toList()));
            if (i > 0) {
                tab.withTabsBefore(new ResourceLocation[]{CreativeModeTabs.f_256731_.m_135782_(), (ResourceLocation)newTabs.get(i - 1).getKey()});
            } else {
                tab.withTabsBefore(new ResourceLocation[]{CreativeModeTabs.f_256731_.m_135782_()});
            }
            if (i < newTabs.size() - 1) {
                tab.withTabsAfter(new ResourceLocation[]{(ResourceLocation)newTabs.get(i + 1).getKey()});
            }
            Registry.m_122965_((Registry)BuiltInRegistries.f_279662_, (ResourceLocation)key, (Object)tab.m_257652_());
        }
        if (Platform.isDataGen()) {
            BlockFamilies.reloadResources(resourceManager, context);
        } else {
            modEventBus.addListener(event -> {
                BlockFamilies.reloadResources(resourceManager, context);
                BuilderRules.reload(resourceManager, context);
            });
        }
    }

    private static void insertToTab(IEventBus modEventBus, KCreativeTab kCreativeTab) {
        if (!Platform.isPhysicalClient()) {
            return;
        }
        modEventBus.addListener(event -> {
            if (event.getTabKey() != kCreativeTab.insert().orElseThrow()) {
                return;
            }
            for (ResourceKey<Item> content : kCreativeTab.contents()) {
                Item item = (Item)BuiltInRegistries.f_257033_.m_6246_(content);
                if (item == null) {
                    return;
                }
                event.m_246326_((ItemLike)item);
            }
        });
    }

    public static ResourceManager collectKiwiPacks() {
        CustomizationServiceFinder.PACK_DIRECTORY.toFile().mkdirs();
        RequiredFolderRepositorySource folderRepositorySource = new RequiredFolderRepositorySource(CustomizationServiceFinder.PACK_DIRECTORY, PackType.CLIENT_RESOURCES, PackSource.f_10528_);
        PackRepository packRepository = new PackRepository(new RepositorySource[]{folderRepositorySource});
        ResourcePackLoader.loadResourcePacks((PackRepository)packRepository, CustomizationHooks::buildPackFinder);
        packRepository.m_10506_();
        ArrayList selected = Lists.newArrayList((Iterable)packRepository.m_10514_());
        selected.remove("mod_resources");
        selected.add(0, "mod_resources");
        packRepository.m_10509_((Collection)selected);
        return new KiwiPackResourceManager(packRepository.m_10525_());
    }

    private static RepositorySource buildPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks) {
        return packAcceptor -> CustomizationHooks.clientPackFinder(modResourcePacks, packAcceptor);
    }

    private static void clientPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks, Consumer<Pack> packAcceptor) {
        ArrayList<PathPackResources> hiddenPacks = new ArrayList<PathPackResources>();
        for (Map.Entry<IModFile, ? extends PathPackResources> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            String name = "mod:" + mod.getModId();
            Pack modPack = Pack.m_245429_((String)name, (Component)Component.m_237113_((String)e.getValue().m_5542_()), (boolean)false, id -> (PackResources)e.getValue(), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
            if (modPack == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                continue;
            }
            Kiwi.LOGGER.debug("Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            if (mod.getOwningFile().showAsResourcePack()) {
                packAcceptor.accept(modPack);
                continue;
            }
            hiddenPacks.add(e.getValue());
        }
        Pack modResourcesPack = Pack.m_245429_((String)"mod_resources", (Component)Component.m_237113_((String)"Mod Resources"), (boolean)true, id -> new DelegatingPackResources(id, false, new PackMetadataSection((Component)Component.m_237110_((String)"fml.resources.modresources", (Object[])new Object[]{hiddenPacks.size()}), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES)), (List)hiddenPacks), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
        packAcceptor.accept(modResourcesPack);
    }

    public static Set<String> getBlockNamespaces() {
        return blockNamespaces;
    }

    public static Set<String> getLenientBETypeNamespaces() {
        return lenientBETypeNamespaces;
    }

    public static boolean isColorlessGlass(BlockState blockState) {
        return blockState.m_204336_(Tags.Blocks.GLASS_COLORLESS);
    }

    public static GlassType clearGlassType() {
        return clearGlassType;
    }

    @KiwiModule.LoadingCondition(value={"block_components", "block_templates", "item_templates", "builder_rules"})
    public static boolean shouldLoad(LoadingContext ctx) {
        return CustomizationHooks.isEnabled();
    }

    static {
        OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
            Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(512, 0.25f){

                protected void rehash(int needed) {
                }
            };
            object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
            return object2bytelinkedopenhashmap;
        });
    }
}

