/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.StringUtils;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.builder.BlockSpread;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.BuilderRuleTypes;

public record CyclePropertyRule(Map<BlockFamily, Map<String, String>> families, BlockSpread spread, Map<Block, Map<Property<?>, Set<Object>>> blocks) implements BuilderRule
{
    public static final MapCodec<CyclePropertyRule> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap(BlockFamily.CODEC, (Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING)).fieldOf("family").forGetter(CyclePropertyRule::families), (App)BlockSpread.CODEC.fieldOf("spread").forGetter(CyclePropertyRule::spread)).apply((Applicative)instance, CyclePropertyRule::of));

    public static CyclePropertyRule of(Map<BlockFamily, Map<String, String>> families, BlockSpread spread) {
        ImmutableMap.Builder blocks = ImmutableMap.builder();
        Interner interner = Interners.newStrongInterner();
        Interner valuesInterner = Interners.newStrongInterner();
        for (Map.Entry<BlockFamily, Map<String, String>> entry : families.entrySet()) {
            for (Block block : entry.getKey().blocks().toList()) {
                ImmutableMap.Builder properties = ImmutableMap.builder();
                for (Map.Entry<String, String> propEntry : entry.getValue().entrySet()) {
                    try {
                        Property<?> property = KBlockUtils.getProperty(block.m_49966_(), propEntry.getKey());
                        if (propEntry.getValue().equals("*")) {
                            properties.put(property, Set.of());
                            continue;
                        }
                        String[] values = StringUtils.split((String)propEntry.getValue(), (char)'|');
                        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
                        for (String value : values) {
                            Optional opt = property.m_6215_(value);
                            if (opt.isPresent()) {
                                setBuilder.add(opt.get());
                                continue;
                            }
                            Kiwi.LOGGER.warn("Invalid value {} for property {} on block {}", new Object[]{value, property, block});
                        }
                        ImmutableSet set = setBuilder.build();
                        if (set.isEmpty()) continue;
                        properties.put(property, (Object)((Set)valuesInterner.intern((Object)set)));
                    }
                    catch (Exception exception) {}
                }
                ImmutableMap map = properties.build();
                if (map.isEmpty()) continue;
                blocks.put((Object)block, (Object)((Map)interner.intern((Object)map)));
            }
        }
        return new CyclePropertyRule(families, spread, (Map<Block, Map<Property<?>, Set<Object>>>)blocks.build());
    }

    @Override
    public BuilderRule.Type<?> type() {
        return BuilderRuleTypes.CYCLE_PROPERTY.getOrCreate();
    }

    @Override
    public Stream<Block> relatedBlocks() {
        return this.blocks.keySet().stream();
    }

    @Override
    public boolean matches(Player player, ItemStack itemStack, BlockState blockState) {
        return true;
    }

    @Override
    public void apply(UseOnContext context, List<BlockPos> positions) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        boolean success = false;
        HashMap usedBlocks = Maps.newHashMap();
        for (BlockPos pos : positions) {
            BlockState oldBlock;
            BlockState newBlock = oldBlock = level.m_8055_(pos);
            Block block = oldBlock.m_60734_();
            BlockState usedBlock = (BlockState)usedBlocks.get(block);
            for (Map.Entry<Property<?>, Set<Object>> propEntry : this.blocks.get(block).entrySet()) {
                Comparable value;
                Property<?> property = propEntry.getKey();
                Set<Object> values = propEntry.getValue();
                Comparable curValue = oldBlock.m_61143_(property);
                if (!values.isEmpty() && !values.contains(curValue)) continue;
                Comparable comparable = value = usedBlock == null ? null : usedBlock.m_61143_(property);
                if (!values.isEmpty() && !values.contains(value)) {
                    value = null;
                }
                if (value == null) {
                    while (!((value = (newBlock = (BlockState)newBlock.m_61122_(property)).m_61143_(property)).equals(curValue) || values.isEmpty() || values.contains(value))) {
                    }
                    continue;
                }
                newBlock = (BlockState)newBlock.m_61124_(property, value);
            }
            if (!newBlock.m_60710_((LevelReader)level, pos)) continue;
            if (usedBlock == null) {
                usedBlocks.put(block, newBlock);
            }
            success |= level.m_7731_(pos, newBlock, 18);
        }
        if (success && player != null) {
            for (BlockState block : usedBlocks.values()) {
                this.playPlaceSound(player, block);
            }
        }
    }

    @Override
    public List<BlockPos> searchPositions(BlockState blockState, UseOnContext context) {
        List<BlockPos> list = List.of();
        HashMap usedBlocks = Maps.newHashMap();
        try {
            list = this.spread.collect(context, $ -> {
                Set<Object> values;
                Property<?> property;
                Block block = $.m_60734_();
                Map<Property<?>, Set<Object>> map = this.blocks.get(block);
                if (map == null) {
                    return false;
                }
                BlockState usedBlock = (BlockState)usedBlocks.get(block);
                for (Map.Entry<Property<?>, Set<Object>> entry : map.entrySet()) {
                    property = entry.getKey();
                    values = entry.getValue();
                    Comparable curValue = $.m_61143_(property);
                    if (usedBlock == null || !values.isEmpty() && !values.contains(curValue) || curValue.equals(usedBlock.m_61143_(property))) continue;
                    return false;
                }
                if (usedBlock != $) {
                    if (usedBlock != null) {
                        for (Map.Entry<Property<?>, Set<Object>> entry : map.entrySet()) {
                            property = entry.getKey();
                            values = entry.getValue();
                            Comparable value = $.m_61143_(property);
                            if (!values.isEmpty() && !values.contains(value)) continue;
                            usedBlock = (BlockState)usedBlock.m_61124_(property, value);
                        }
                    }
                    usedBlocks.put(block, usedBlock);
                }
                return true;
            }, null);
        }
        catch (Exception e) {
            Kiwi.LOGGER.error("Failed to collect positions", (Throwable)e);
        }
        return list;
    }
}

