/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.shape.BlockShapeType;
import snownee.kiwi.customization.shape.ConfiguringShape;
import snownee.kiwi.customization.shape.ShapeStorage;

public record ConfigureWallShape(float width, float depth, float wallPostHeight, float wallMinY, float wallLowHeight, float wallTallHeight) implements ConfiguringShape
{
    public static Codec<ConfigureWallShape> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("post_width").forGetter(ConfigureWallShape::width), (App)Codec.FLOAT.fieldOf("side_width").forGetter(ConfigureWallShape::depth), (App)Codec.FLOAT.fieldOf("post_max_y").forGetter(ConfigureWallShape::wallPostHeight), (App)Codec.FLOAT.fieldOf("side_min_y").forGetter(ConfigureWallShape::wallMinY), (App)Codec.FLOAT.fieldOf("low_side_max_y").forGetter(ConfigureWallShape::wallLowHeight), (App)Codec.FLOAT.fieldOf("tall_side_max_y").forGetter(ConfigureWallShape::wallTallHeight)).apply((Applicative)instance, ConfigureWallShape::new));
    }

    @Override
    public void configure(Block block, BlockShapeType type, ShapeStorage storage) {
        if (!(block instanceof WallBlock)) {
            throw new IllegalArgumentException("Block %s is not a WallBlock".formatted(block));
        }
        WallBlock wallBlock = (WallBlock)block;
        Map shapes = wallBlock.m_57965_(this.width / 2.0f, this.depth / 2.0f, this.wallPostHeight, this.wallMinY, this.wallLowHeight, this.wallTallHeight);
        switch (type) {
            case MAIN: {
                wallBlock.f_57955_ = shapes;
                break;
            }
            case COLLISION: {
                wallBlock.f_57956_ = shapes;
                break;
            }
            case INTERACTION: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void replaceAll(Block block, BlockShapeType type, UnaryOperator<VoxelShape> operator) {
        if (!(block instanceof WallBlock)) {
            throw new IllegalArgumentException("Block %s is not a WallBlock".formatted(block));
        }
        WallBlock wallBlock = (WallBlock)block;
        if (type == BlockShapeType.INTERACTION) {
            throw new UnsupportedOperationException("Interaction shapes cannot be replaced for WallBlock");
        }
        Map shapes = switch (type) {
            case BlockShapeType.MAIN -> wallBlock.f_57955_;
            case BlockShapeType.COLLISION -> wallBlock.f_57956_;
            default -> throw new IllegalStateException();
        };
        IdentityHashMap newShapes = Maps.newIdentityHashMap();
        for (Map.Entry entry : shapes.entrySet()) {
            newShapes.put((BlockState)entry.getKey(), (VoxelShape)operator.apply((VoxelShape)entry.getValue()));
        }
        switch (type) {
            case MAIN: {
                wallBlock.f_57955_ = newShapes;
                break;
            }
            case COLLISION: {
                wallBlock.f_57956_ = newShapes;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

