/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.platform;

import it.crystalnest.harvest_with_ease.Constants;
import it.crystalnest.harvest_with_ease.platform.services.EventHelper;
import it.crystalnest.harvest_with_ease.platform.services.HarvestHelper;
import it.crystalnest.harvest_with_ease.platform.services.PlatformHelper;
import java.util.ServiceLoader;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Services {
    public static final PlatformHelper PLATFORM = Services.load(PlatformHelper.class);
    public static final EventHelper EVENT = Services.load(EventHelper.class);
    public static final HarvestHelper HARVEST = Services.load(HarvestHelper.class);

    private Services() {
    }

    private static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

