/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoyalJellyBlock
extends HalfTransparentBlock
implements BlockExtension {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public RoyalJellyBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60956_(0.4f).m_60967_(0.5f).m_60955_().m_60918_(SoundType.f_56751_));
    }

    @Override
    public boolean bz$isStickyBlock(BlockState state) {
        return state.m_60734_() == BzBlocks.ROYAL_JELLY_BLOCK.get();
    }

    @Override
    public OptionalBoolean bz$canStickTo(BlockState state, BlockState other) {
        if (state.m_60734_() == BzBlocks.ROYAL_JELLY_BLOCK.get()) {
            if (other.m_60734_() == Blocks.f_50719_ || other.m_60734_() == Blocks.f_50374_) {
                return OptionalBoolean.FALSE;
            }
            return OptionalBoolean.TRUE;
        }
        return OptionalBoolean.EMPTY;
    }

    public static boolean isValidMoveDirection(Direction pushDirection, Direction pistonDirection) {
        return pushDirection == null || pushDirection != pistonDirection;
    }

    private static boolean doesEntityDoHoneyBlockSlideEffects(Entity entity) {
        return entity instanceof LivingEntity || entity instanceof AbstractMinecart || entity instanceof PrimedTnt || entity instanceof Boat;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float fallDistance) {
        entity.m_5496_(BzSounds.ROYAL_JELLY_BLOCK_SLIDE.get(), 1.0f, 1.0f);
        if (!level.f_46443_) {
            RoyalJellyBlock.showJumpParticles((ServerLevel)level, entity);
        }
        if (entity.m_142535_(fallDistance, 0.2f, level.m_269111_().m_268989_())) {
            entity.m_5496_(this.f_60446_.m_56779_(), this.f_60446_.m_56773_() * 0.5f, this.f_60446_.m_56774_() * 0.75f);
        }
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (this.isSlidingDown(blockPos, entity)) {
            this.maybeDoSlideAchievement(entity, blockPos);
            this.doSlideMovement(entity);
            this.maybeDoSlideEffects(level, entity);
        }
        super.m_7892_(blockState, level, blockPos, entity);
    }

    private boolean isSlidingDown(BlockPos blockPos, Entity entity) {
        if (entity.m_20096_()) {
            return false;
        }
        if (entity.m_20186_() > (double)blockPos.m_123342_() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (entity.m_20184_().f_82480_ >= -0.08) {
            return false;
        }
        double d0 = Math.abs((double)blockPos.m_123341_() + 0.5 - entity.m_20185_());
        double d1 = Math.abs((double)blockPos.m_123343_() + 0.5 - entity.m_20189_());
        double d2 = 0.4375 + (double)(entity.m_20205_() / 2.0f);
        return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
    }

    private void maybeDoSlideAchievement(Entity entity, BlockPos blockPos) {
        ServerPlayer serverPlayer;
        if (entity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)entity).m_9236_().m_46467_() % 20L == 0L) {
            CriteriaTriggers.f_10559_.m_66978_(serverPlayer, serverPlayer.m_9236_().m_8055_(blockPos));
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState blockState, LivingEntity entity, ItemStack itemStack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            boolean nextToStickyPiston = false;
            for (Direction direction : Direction.values()) {
                if (!level.m_8055_(pos.m_121945_(direction)).m_60713_(Blocks.f_50032_)) continue;
                nextToStickyPiston = true;
                break;
            }
            if (nextToStickyPiston) {
                BzCriterias.ROYAL_JELLY_BLOCK_PISTON_TRIGGER.trigger(serverPlayer);
            }
        }
    }

    private void doSlideMovement(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        if (vec3.f_82480_ < -0.13) {
            double d0 = -0.05 / vec3.f_82480_;
            entity.m_20256_(new Vec3(vec3.f_82479_ * d0, -0.05, vec3.f_82481_ * d0));
        } else {
            entity.m_20256_(new Vec3(vec3.f_82479_, -0.05, vec3.f_82481_));
        }
        entity.m_183634_();
    }

    private void maybeDoSlideEffects(Level level, Entity entity) {
        if (RoyalJellyBlock.doesEntityDoHoneyBlockSlideEffects(entity)) {
            if (level.m_213780_().m_188503_(5) == 0) {
                entity.m_5496_(BzSounds.ROYAL_JELLY_BLOCK_SLIDE.get(), 1.0f, 1.0f);
            }
            if (!level.f_46443_ && level.m_213780_().m_188503_(5) == 0) {
                RoyalJellyBlock.showSlideParticles((ServerLevel)level, entity);
            }
        }
    }

    public static void showSlideParticles(ServerLevel serverLevel, Entity entity) {
        RoyalJellyBlock.showParticles(serverLevel, entity, 5);
    }

    public static void showJumpParticles(ServerLevel serverLevel, Entity entity) {
        RoyalJellyBlock.showParticles(serverLevel, entity, 10);
    }

    private static void showParticles(ServerLevel serverLevel, Entity entity, int particleNumber) {
        BlockState blockstate = BzBlocks.ROYAL_JELLY_BLOCK.get().m_49966_();
        for (int i = 0; i < particleNumber; ++i) {
            serverLevel.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0, 0.0, 0.0);
        }
    }
}

