/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.fluids.RoyalJellyFluid;
import com.telepathicgrunt.the_bumblezone.fluids.base.BzLiquidBlock;
import com.telepathicgrunt.the_bumblezone.fluids.base.FluidInfo;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;

public class RoyalJellyFluidBlock
extends BzLiquidBlock {
    public static final int maxBottomLayer = 8;

    public RoyalJellyFluidBlock(FluidInfo baseFluid) {
        super(baseFluid, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283892_).m_278788_().m_60910_().m_60913_(100.0f, 100.0f).m_60956_(0.15f).m_222994_().m_280170_().m_60918_(SoundType.f_279557_).m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54688_, (Comparable)Integer.valueOf(0))).m_61124_((Property)HoneyFluidBlock.BOTTOM_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FlowingFluid.f_75947_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{f_54688_, HoneyFluidBlock.BOTTOM_LEVEL, FlowingFluid.f_75947_, HoneyFluidBlock.ABOVE_FLUID});
    }

    public void m_6861_(BlockState blockState, Level world, BlockPos blockPos, Block block, BlockPos fromPos, boolean notify) {
        if (this.neighboringFluidInteractions(world, blockPos)) {
            world.m_186469_(blockPos, blockState.m_60819_().m_76152_(), RoyalJellyFluid.adjustedFlowSpeed(this.getFluid().m_6718_((LevelReader)world), (LevelAccessor)world, blockPos));
        }
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState previousBlockState, LevelAccessor level, BlockPos blockPos, BlockPos blockPos1) {
        if (blockState.m_60819_().m_76170_() || previousBlockState.m_60819_().m_76170_()) {
            level.m_186469_(blockPos, blockState.m_60819_().m_76152_(), RoyalJellyFluid.adjustedFlowSpeed(this.getFluid().m_6718_((LevelReader)level), level, blockPos));
        }
        return super.m_7417_(blockState, direction, previousBlockState, level, blockPos, blockPos1);
    }

    public void m_6807_(BlockState blockState, Level world, BlockPos blockPos, BlockState previousBlockState, boolean notify) {
        if (this.neighboringFluidInteractions(world, blockPos)) {
            world.m_186469_(blockPos, blockState.m_60819_().m_76152_(), RoyalJellyFluid.adjustedFlowSpeed(this.getFluid().m_6718_((LevelReader)world), (LevelAccessor)world, blockPos));
        }
    }

    private boolean neighboringFluidInteractions(Level world, BlockPos pos) {
        boolean lavaflag = false;
        boolean lavadownflag = false;
        for (Direction direction : Direction.values()) {
            BlockPos sidePos = pos.m_121945_(direction);
            FluidState sideFluid = world.m_6425_(sidePos);
            if (sideFluid.m_205070_(FluidTags.f_13132_)) {
                lavaflag = true;
                if (direction != Direction.DOWN) break;
                lavadownflag = true;
                break;
            }
            if (sideFluid.m_76178_() || sideFluid.m_205070_(BzTags.HONEY_FLUID)) continue;
            FluidState currentFluid = world.m_6425_(pos);
            if (direction == Direction.DOWN && currentFluid.m_61138_((Property)HoneyFluidBlock.BOTTOM_LEVEL) && (Integer)currentFluid.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) != 0) continue;
            if (direction == Direction.UP) {
                world.m_7731_(pos, BzBlocks.GLISTERING_HONEY_CRYSTAL.get().m_49966_(), 3);
                return false;
            }
            BlockState sideState = world.m_8055_(sidePos);
            if (sideState.m_60734_() instanceof LiquidBlock || !sideState.m_60819_().m_76178_() || sideState.m_247087_()) {
                world.m_7731_(sidePos, BzBlocks.GLISTERING_HONEY_CRYSTAL.get().m_49966_(), 3);
                continue;
            }
            if (currentFluid.m_76170_()) continue;
            world.m_7731_(pos, BzBlocks.GLISTERING_HONEY_CRYSTAL.get().m_49966_(), 3);
            return false;
        }
        if (lavaflag) {
            BlockState moddedResultBlockState;
            FluidState currentFluid = world.m_6425_(pos);
            if (currentFluid.m_76170_()) {
                BlockState resultBlockState = BzBlocks.SUGAR_INFUSED_STONE.get().m_49966_();
                for (ModCompat compat : ModChecker.HONEY_FLUID_LAVA_INTERACTION_COMPATS) {
                    moddedResultBlockState = compat.honeyLavaResultBlock(currentFluid);
                    if (moddedResultBlockState == null) continue;
                    resultBlockState = moddedResultBlockState;
                }
                world.m_46597_(pos, resultBlockState);
                this.triggerMixEffects(world, pos);
                return false;
            }
            if (!lavadownflag || currentFluid.m_61138_((Property)HoneyFluidBlock.BOTTOM_LEVEL) && (Integer)currentFluid.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL) == 0) {
                BlockState resultBlockState = BzBlocks.SUGAR_INFUSED_COBBLESTONE.get().m_49966_();
                for (ModCompat compat : ModChecker.HONEY_FLUID_LAVA_INTERACTION_COMPATS) {
                    moddedResultBlockState = compat.honeyLavaResultBlock(currentFluid);
                    if (moddedResultBlockState == null) continue;
                    resultBlockState = moddedResultBlockState;
                }
                world.m_46597_(pos, resultBlockState);
                this.triggerMixEffects(world, pos);
                return false;
            }
        }
        return true;
    }

    public FluidState m_5888_(BlockState blockState) {
        int fluidLevel = Math.min(Math.max((Integer)blockState.m_61143_((Property)f_54688_), 0), 8);
        int bottomFluidLevel = Math.min(Math.max((Integer)blockState.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL), 0), 8);
        boolean isFalling = (Boolean)blockState.m_61143_((Property)FlowingFluid.f_75947_);
        FluidState fluidState = fluidLevel == 0 ? this.getFluid().m_76068_(false) : (FluidState)this.getFluid().m_75953_(fluidLevel, isFalling).m_61124_((Property)HoneyFluidBlock.BOTTOM_LEVEL, (Comparable)Integer.valueOf(bottomFluidLevel));
        return (FluidState)fluidState.m_61124_((Property)HoneyFluidBlock.ABOVE_FLUID, (Comparable)((Boolean)blockState.m_61143_((Property)HoneyFluidBlock.ABOVE_FLUID)));
    }

    public void m_7892_(BlockState state, Level world, BlockPos position, Entity entity) {
        ServerPlayer serverPlayer;
        Bee beeEntity;
        double verticalSpeedDeltaLimit = 0.01;
        if (entity instanceof Bee && !(beeEntity = (Bee)entity).m_21224_()) {
            if (PlatformHooks.isEyesInNoFluid(entity)) {
                if (beeEntity.m_21223_() < beeEntity.m_21233_()) {
                    float diff = beeEntity.m_21233_() - beeEntity.m_21223_();
                    beeEntity.m_5634_(diff);
                }
                beeEntity.m_7292_(new MobEffectInstance(BzEffects.BEENERGIZED.get(), 600, 0, false, true, true));
                beeEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 600, 0, false, false, true));
            } else {
                beeEntity.m_21195_(MobEffects.f_19605_);
            }
        } else if (Math.abs(entity.m_20184_().m_7098_()) > verticalSpeedDeltaLimit && (double)entity.f_19789_ <= 0.2) {
            Vec3 vec3 = entity.m_20184_();
            entity.m_20256_(new Vec3(vec3.m_7096_(), Math.copySign(verticalSpeedDeltaLimit, vec3.m_7098_()), vec3.m_7094_()));
        }
        if (entity instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)entity)) {
            serverPlayer.m_7292_(new MobEffectInstance(BzEffects.BEENERGIZED.get(), 300, 0, false, true, true));
            serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1, false, false, true));
        }
        super.m_7892_(state, world, position, entity);
    }

    private void triggerMixEffects(Level world, BlockPos pos) {
        world.m_46796_(1501, pos, 0);
    }
}

