/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.entities.nonliving.SentryWatcherEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryWatcherSpawnEgg
extends Item {
    private final Supplier<? extends EntityType<? extends Entity>> entityType;
    public static final UUID DISPENSER_OWNER_UUID = new UUID(0L, 0L);

    public SentryWatcherSpawnEgg(Supplier<? extends EntityType<? extends Entity>> typeIn, Item.Properties builder) {
        super(builder);
        this.entityType = typeIn;
        this.setupDispenserBehavior();
    }

    protected void setupDispenserBehavior() {
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack m_7498_(@NotNull BlockSource source, @NotNull ItemStack stack) {
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                EntityType<?> entitytype = ((SentryWatcherSpawnEgg)stack.m_41720_()).getType(stack.m_41783_());
                Entity entity = entitytype.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_121945_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                if (entity instanceof SentryWatcherEntity) {
                    SentryWatcherEntity sentryWatcherEntity = (SentryWatcherEntity)entity;
                    sentryWatcherEntity.setTargetFacing(direction);
                    sentryWatcherEntity.setOwner(Optional.of(DISPENSER_OWNER_UUID));
                }
                stack.m_41774_(1);
                return stack;
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        Player player = useOnContext.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = useOnContext.m_43722_();
        BlockPos blockPos = useOnContext.m_8083_();
        Direction direction = useOnContext.m_43719_();
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_60713_(Blocks.f_50085_)) {
            if (!player.m_150110_().f_35937_) {
                if (player instanceof ServerPlayer) {
                    player.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.sentry_watcher_egg_spawner_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), true);
                }
                return InteractionResult.FAIL;
            }
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                EntityType<?> entityType = this.getType(itemStack.m_41783_());
                spawnerBlockEntity.m_252803_(entityType, level.m_213780_());
                blockEntity.m_6596_();
                level.m_7260_(blockPos, blockState, blockState, 3);
                level.m_142346_((Entity)useOnContext.m_43723_(), GameEvent.f_157792_, blockPos);
                itemStack.m_41774_(1);
                return InteractionResult.CONSUME;
            }
        }
        BlockPos blockPos2 = blockState.m_60812_((BlockGetter)level, blockPos).m_83281_() ? blockPos : blockPos.m_121945_(direction);
        EntityType<?> entityType2 = this.getType(itemStack.m_41783_());
        Entity entity = entityType2.m_20592_((ServerLevel)level, itemStack, useOnContext.m_43723_(), blockPos2, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, blockPos2) && direction == Direction.UP);
        if (entity != null) {
            if (entity instanceof SentryWatcherEntity) {
                SentryWatcherEntity sentryWatcherEntity = (SentryWatcherEntity)entity;
                if (useOnContext.m_43719_().m_122434_() != Direction.Axis.Y) {
                    sentryWatcherEntity.setTargetFacing(useOnContext.m_8125_().m_122424_());
                } else {
                    sentryWatcherEntity.setTargetFacing(useOnContext.m_8125_());
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    BzCriterias.SENTRY_WATCHER_SPAWN_EGG_USED_TRIGGER.trigger(serverPlayer);
                }
                sentryWatcherEntity.setOwner(Optional.of(player.m_20148_()));
                if (player instanceof ServerPlayer) {
                    player.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.sentry_watcher_egg_removal_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), true);
                }
            }
            itemStack.m_41774_(1);
            level.m_142346_((Entity)useOnContext.m_43723_(), GameEvent.f_157810_, blockPos);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockHitResult blockHitResult = SentryWatcherSpawnEgg.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        if (!(level.m_8055_(blockPos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (level.m_7966_(player, blockPos) && player.m_36204_(blockPos, blockHitResult.m_82434_(), itemStack)) {
            EntityType<?> entityType = this.getType(itemStack.m_41783_());
            Entity entity = entityType.m_20592_((ServerLevel)level, itemStack, player, blockPos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            if (entity instanceof SentryWatcherEntity) {
                SentryWatcherEntity sentryWatcherEntity = (SentryWatcherEntity)entity;
                sentryWatcherEntity.setTargetFacing(player.m_6350_());
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    BzCriterias.SENTRY_WATCHER_SPAWN_EGG_USED_TRIGGER.trigger(serverPlayer);
                }
                if (!player.m_150110_().f_35937_) {
                    sentryWatcherEntity.setOwner(Optional.of(player.m_20148_()));
                    if (player instanceof ServerPlayer) {
                        player.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.sentry_watcher_egg_removal_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD), true);
                    }
                }
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            level.m_220400_((Entity)player, GameEvent.f_157810_, entity.m_20182_());
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public EntityType<?> getType(@Nullable CompoundTag compoundTag) {
        CompoundTag compoundTag2;
        if (compoundTag != null && compoundTag.m_128425_("EntityTag", 10) && (compoundTag2 = compoundTag.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_((String)compoundTag2.m_128461_("id")).orElse(this.entityType.get());
        }
        return this.entityType.get();
    }
}

