/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockXPSolidifier;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.models.ModelXPSolidifier;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityXPSolidifierRenderer
implements BlockEntityRenderer<TileEntityXPSolidifier> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/xp_solidifier.png");
    private static final ResourceLocation TEXTURE_NO_PUSH = new ResourceLocation("mob_grinding_utils:textures/tiles/xp_solidifier_no_push.png");
    private final ModelXPSolidifier xp_solidifier_model;

    public TileEntityXPSolidifierRenderer(BlockEntityRendererProvider.Context context) {
        this.xp_solidifier_model = new ModelXPSolidifier(context.m_173582_(ModelLayers.XPSOLIDIFIER));
    }

    public void render(TileEntityXPSolidifier tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.m_58898_()) {
            return;
        }
        BlockState state = tile.m_58904_().m_8055_(tile.m_58899_());
        if (state == null || state.m_60734_() != ModBlocks.XPSOLIDIFIER.getBlock()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockXPSolidifier.FACING);
        float ticks = (float)tile.prevAnimationTicks + (float)(tile.animationTicks - tile.prevAnimationTicks) * partialTicks;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_85841_(-0.9999f, -0.9999f, 0.9999f);
        switch (tile.outputDirection) {
            case NONE: 
            case NORTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case SOUTH: {
                matrixStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                matrixStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                break;
            }
            default: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.renderExport(matrixStack, bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)(tile.outputDirection == TileEntityXPSolidifier.OutputDirection.NONE ? TEXTURE_NO_PUSH : TEXTURE))), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_85841_(-0.9999f, -0.9999f, 0.9999f);
        switch (facing) {
            case NORTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case SOUTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                matrixStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
                break;
            }
            case EAST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
        }
        matrixStack.m_85836_();
        RenderSystem.enableBlend();
        if (ticks > 0.0f && ticks <= 20.0f) {
            matrixStack.m_85837_(0.0, (double)(ticks * 0.009375f), 0.0);
        }
        if (ticks > 20.0f && ticks <= 60.0f) {
            matrixStack.m_85837_(0.0, 0.1875, 0.0);
        }
        if (ticks > 60.0f && ticks <= 80.0f) {
            matrixStack.m_85837_(0.0, (double)((80.0f - ticks) * 0.009375f), 0.0);
        }
        if (ticks > 80.0f || ticks <= 0.0f) {
            matrixStack.m_85837_(0.0, 0.0, 0.0);
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.renderRack(matrixStack, bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.60625, -0.22);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_85841_(1.25f, 1.25f, 1.25f);
        ItemStack stackMould = tile.inputSlots.getStackInSlot(0);
        if (!stackMould.m_41619_()) {
            Minecraft.m_91087_().m_91097_().m_174784_(InventoryMenu.f_39692_);
            Minecraft.m_91087_().m_91291_().m_115143_(stackMould, ItemDisplayContext.GROUND, false, matrixStack, bufferIn, combinedLight, combinedOverlay, Minecraft.m_91087_().m_91291_().m_174264_(stackMould, null, null, 0));
        }
        matrixStack.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.m_85849_();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.m_7695_(matrixStack, bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.79375, -0.22);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_85841_(1.25f, 1.25f, 1.25f);
        ItemStack stackResult = tile.outputSlot.getStackInSlot(0);
        if (stackResult.m_41619_() && !tile.getCachedOutPutRenderStack().m_41619_() && tile.getProgress() > 60) {
            Minecraft.m_91087_().m_91097_().m_174784_(InventoryMenu.f_39692_);
            Minecraft.m_91087_().m_91291_().m_115143_(tile.getCachedOutPutRenderStack(), ItemDisplayContext.GROUND, false, matrixStack, bufferIn, combinedLight, combinedOverlay, Minecraft.m_91087_().m_91291_().m_174264_(tile.getCachedOutPutRenderStack(), null, null, 0));
        } else if (!stackResult.m_41619_()) {
            Minecraft.m_91087_().m_91097_().m_174784_(InventoryMenu.f_39692_);
            Minecraft.m_91087_().m_91291_().m_115143_(stackResult, ItemDisplayContext.GROUND, false, matrixStack, bufferIn, combinedLight, combinedOverlay, Minecraft.m_91087_().m_91291_().m_174264_(stackResult, null, null, 0));
        }
        matrixStack.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.m_85849_();
        if (tile.tank.getFluid().isEmpty()) {
            return;
        }
        float fluidLevel = tile.tank.getFluidAmount();
        if (fluidLevel < 1.0f) {
            return;
        }
        FluidStack fluidStack = new FluidStack(tile.tank.getFluid(), 100);
        float height = 0.46875f / (float)tile.tank.getCapacity() * (float)tile.tank.getFluidAmount();
        IClientFluidTypeExtensions fluidExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidExtensions.getStillTexture());
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110466_());
        int fluidColor = fluidExtensions.getTintColor();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 0.0);
        float yMin = 0.0f;
        float xMax = 1.984375f;
        float zMax = 1.984375f;
        float xMin = 0.015625f;
        float zMin = 0.015625f;
        yMin = 0.015625f;
        float alpha = 1.0f;
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
        matrixStack.m_85849_();
        if (ticks > 20.0f && ticks < 60.0f && !stackMould.m_41619_()) {
            matrixStack.m_85836_();
            switch (facing) {
                case NORTH: {
                    matrixStack.m_85837_(0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    matrixStack.m_85837_(0.0, 0.0, 0.125);
                    break;
                }
                case WEST: {
                    matrixStack.m_85837_(-0.0625, 0.0, 0.0625);
                    break;
                }
                case EAST: {
                    matrixStack.m_85837_(0.0625, 0.0, 0.0625);
                    break;
                }
            }
            xMax = 1.62f;
            zMax = 1.5f;
            xMin = 0.38f;
            zMin = 0.25f;
            yMin = 0.6875f;
            this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, 0.6875f + ticks * 6.25E-4f, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
            matrixStack.m_85849_();
        }
    }

    private void renderCuboid(VertexConsumer buffer, PoseStack matrixStack, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite, float red, float green, float blue, float alpha, int combinedLight) {
        float uMin = textureAtlasSprite.m_118409_();
        float uMax = textureAtlasSprite.m_118410_();
        float vMin = textureAtlasSprite.m_118411_();
        float vMax = textureAtlasSprite.m_118412_();
        float vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMax, red, green, blue, alpha, combinedLight);
    }

    private void addVertexWithUV(VertexConsumer buffer, PoseStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, int combinedLight) {
        buffer.m_252986_(matrixStack.m_85850_().m_252922_(), x / 2.0f, y, z / 2.0f).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_7120_(combinedLight, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }
}

