/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.clibano;

import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoMenu;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClibanoItemHandler
implements IItemHandler {
    private static final int SOUL_SLOT = 1;
    private static final int FUEL_SLOT = 2;
    private static final Pair<Integer, Integer> INPUT_SLOTS = ClibanoMenu.INPUT_SLOTS;
    public static final Pair<Integer, Integer> RESULT_SLOTS = ClibanoMenu.RESULT_SLOTS;
    private final IItemHandler itemHandler;
    @Nullable
    private final Direction[] sides;

    public ClibanoItemHandler(IItemHandler itemHandler, Direction ... sides) {
        this.itemHandler = itemHandler;
        this.sides = sides;
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.sides.length == 1) {
            if (this.sides[0] == Direction.DOWN) {
                return stack;
            }
            if (this.sides[0] == Direction.UP && (slot == (Integer)INPUT_SLOTS.getFirst() || slot == (Integer)INPUT_SLOTS.getSecond())) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
        } else if (slot == 1 || slot == 2) {
            return this.itemHandler.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.sides.length == 1 && this.sides[0] == Direction.DOWN && slot == (Integer)RESULT_SLOTS.getFirst() || slot == (Integer)RESULT_SLOTS.getSecond()) {
            return this.itemHandler.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }
}

