/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.util.ModTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class BlacksmithGavelLootModifier
extends LootModifier {
    public static final Supplier<Codec<BlacksmithGavelLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> BlacksmithGavelLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BlacksmithGavelLootModifier::new)));

    public BlacksmithGavelLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        ItemStack stack = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (state == null || stack == null) {
            return generatedLoot;
        }
        if (this.isValidGavel(stack) && state.m_204336_(Tags.Blocks.ORES) && !state.m_204336_(ModTags.Blocks.BLACKSMITH_GAVEL_UNAFFECTED)) {
            generatedLoot.addAll((ObjectList)generatedLoot.clone());
        }
        return generatedLoot;
    }

    private boolean isValidGavel(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.BLACKSMITH_GAVEL) && stack.getEnchantmentLevel(Enchantments.f_44985_) == 0;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

