/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stal111.forbidden_arcanus.util.ModUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderUtils {
    public static void renderFluid(IFluidTank fluidTank, FluidStack fluidStack, MultiBufferSource buffer, Matrix4f matrix, Matrix3f normal, AABB boundingBox, int color, int combinedLight, int combinedOverlay) {
        Fluid fluid = fluidStack.getFluid();
        VertexConsumer builder = buffer.m_6299_(Sheets.m_110792_());
        ResourceLocation resourceLocation = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(resourceLocation);
        int light1 = combinedLight & 0xFFFF;
        int light2 = combinedLight >> 16 & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        AABB bounds = RenderUtils.getRenderBounds(fluidTank, boundingBox);
        float x1 = (float)bounds.f_82288_;
        float x2 = (float)bounds.f_82291_;
        float y1 = (float)bounds.f_82289_;
        float y2 = (float)bounds.f_82292_;
        float z1 = (float)bounds.f_82290_;
        float z2 = (float)bounds.f_82293_;
        double bx1 = bounds.f_82288_ * 16.0;
        double bx2 = bounds.f_82291_ * 16.0;
        double by1 = bounds.f_82289_ * 16.0;
        double by2 = bounds.f_82292_ * 16.0;
        double bz1 = bounds.f_82290_ * 16.0;
        double bz2 = bounds.f_82293_ * 16.0;
        for (Direction direction : Direction.values()) {
            float v2;
            float v1;
            float u2;
            float u1;
            if (direction == Direction.DOWN) {
                u1 = texture.m_118367_(bx1);
                u2 = texture.m_118367_(bx2);
                v1 = texture.m_118393_(bz1);
                v2 = texture.m_118393_(bz2);
                builder.m_252986_(matrix, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u2, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (direction == Direction.UP) {
                u1 = texture.m_118367_(bx1);
                u2 = texture.m_118367_(bx2);
                v1 = texture.m_118393_(bz1);
                v2 = texture.m_118393_(bz2);
                builder.m_252986_(matrix, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u1, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (direction == Direction.NORTH) {
                u1 = texture.m_118367_(bx1);
                u2 = texture.m_118367_(bx2);
                v1 = texture.m_118393_(by1);
                v2 = texture.m_118393_(by2);
                builder.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u1, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u2, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (direction == Direction.SOUTH) {
                u1 = texture.m_118367_(bx1);
                u2 = texture.m_118367_(bx2);
                v1 = texture.m_118393_(by1);
                v2 = texture.m_118393_(by2);
                builder.m_252986_(matrix, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u2, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u1, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (direction == Direction.WEST) {
                u1 = texture.m_118367_(by1);
                u2 = texture.m_118367_(by2);
                v1 = texture.m_118393_(bz1);
                v2 = texture.m_118393_(bz2);
                builder.m_252986_(matrix, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (direction != Direction.EAST) continue;
            u1 = texture.m_118367_(by1);
            u2 = texture.m_118367_(by2);
            v1 = texture.m_118393_(bz1);
            v2 = texture.m_118393_(bz2);
            builder.m_252986_(matrix, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v1).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v2).m_86008_(combinedOverlay).m_7120_(light1, light2).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        }
    }

    private static AABB getRenderBounds(IFluidTank tank, AABB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.f_82292_ - tankBounds.f_82289_;
        double y1 = tankBounds.f_82289_;
        double y2 = tankBounds.f_82289_ + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getFluidType().isLighterThanAir()) {
            double yOff = tankBounds.f_82292_ - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AABB(tankBounds.f_82288_, y1, tankBounds.f_82290_, tankBounds.f_82291_, y2, tankBounds.f_82293_);
    }

    public static void addItemParticles(Level level, ItemStack stack, BlockPos pos, int count) {
        RandomSource random = level.m_213780_();
        for (int i = 0; i < count; ++i) {
            Vec3 offset = new Vec3(((double)random.m_188501_() - 0.5) * 0.1, (double)random.m_188501_() * 0.1 + 0.1, 0.0);
            Vec3 vector = new Vec3(((double)random.m_188501_() - 0.5) * 0.3, (double)(-random.m_188501_()) * 0.6 - 0.3, 0.6).m_82549_(ModUtils.blockPosToVector(pos));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vector.f_82479_, vector.f_82480_, vector.f_82481_, 1, offset.f_82479_, offset.f_82480_ + 0.05, offset.f_82481_, 0.0);
                continue;
            }
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vector.f_82479_, vector.f_82480_, vector.f_82481_, offset.f_82479_, offset.f_82480_ + 0.05, offset.f_82481_);
        }
    }
}

