/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.melanx.aiotbotania.AIOTBotania;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.client.core.helper.RenderHelper;

public class ContributorHandler
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public static final Map<UUID, ItemStack> contributorMap = new HashMap<UUID, ItemStack>();
    private static boolean startedLoading = false;

    public ContributorHandler(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public static void firstStart() {
        if (!startedLoading) {
            new ThreadContributorListLoader();
            startedLoading = true;
        }
    }

    public static void load(Properties props) {
        contributorMap.clear();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            ItemStack stack = ContributorHandler.getItem(value);
            if (stack.m_41619_()) {
                AIOTBotania.instance.getLogger().info("Oops, a wrong item at {}. Please report on GitHub. https://www.github.com/MelanX/aiotbotania/issues", (Object)key);
                continue;
            }
            UUID uuid = UUID.fromString(key);
            contributorMap.put(uuid, stack);
        }
    }

    private static ItemStack getItem(String id) {
        ResourceLocation location = new ResourceLocation("aiotbotania", id);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
        if (item == null) {
            AIOTBotania.instance.getLogger().error("Item does not exist: " + location);
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item);
    }

    private void renderIcon(PoseStack poseStack, MultiBufferSource buffers, Player player, ItemStack stack) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252880_(0.15f, -0.17f, 0.13f);
        poseStack.m_85841_(0.15f, 0.15f, 0.15f);
        if (player.m_6047_()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
            poseStack.m_85837_(0.0, -1.76, 0.2);
        }
        RenderHelper.renderItemCustomColor((LivingEntity)player, (ItemStack)stack, (int)-1, (PoseStack)poseStack, (MultiBufferSource)buffers, (int)0xF000F0, (int)OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, AbstractClientPlayer livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (livingEntity.m_20145_()) {
            return;
        }
        ContributorHandler.firstStart();
        UUID uuid = livingEntity.m_36316_().getId();
        if (livingEntity.m_36170_(PlayerModelPart.JACKET) && contributorMap.containsKey(uuid)) {
            this.renderIcon(poseStack, buffer, (Player)livingEntity, contributorMap.get(uuid));
        }
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("AIOT Botania Contributor Thread");
            this.setDaemon(true);
            this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(AIOTBotania.instance.getLogger()));
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://github.com/MelanX/mod-updatechecker-files/raw/master/contributors/aiotbotania.properties");
                Properties props = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                    props.load(reader);
                    ContributorHandler.load(props);
                }
            }
            catch (IOException e) {
                AIOTBotania.instance.getLogger().info("Could not load contributors list. Either you're offline or github is down. Nothing to worry about, carry on~");
            }
        }
    }
}

