var Opcodes = Java.type('org.objectweb.asm.Opcodes');
var InsnNode = Java.type('org.objectweb.asm.tree.InsnNode');
var VarInsnNode = Java.type('org.objectweb.asm.tree.VarInsnNode');
var MethodInsnNode = Java.type('org.objectweb.asm.tree.MethodInsnNode');
var FieldInsnNode = Java.type('org.objectweb.asm.tree.FieldInsnNode');
var JumpInsnNode = Java.type('org.objectweb.asm.tree.JumpInsnNode');
var LabelNode = Java.type('org.objectweb.asm.tree.LabelNode');

var ASMAPI = Java.type('net.minecraftforge.coremod.api.ASMAPI');

function initializeCoreMod() {
	return {
		'getLightColor': {
			'target': {
				'type': 'METHOD',
				'class': 'net.minecraft.client.renderer.LevelRenderer',
				'methodName': 'm_109537_',
				'methodDesc': '(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)I'
			},
			'transformer': getLightColor
		},
		'compileChunksUntil': {
			'target': {
				'type': 'METHOD',
				'class': 'net.minecraft.client.renderer.LevelRenderer',
				'methodName': 'm_109510_',
				'methodDesc': '(J)V'
			},
			'transformer': compileChunksUntil
		},
		'setupRender': {
			'target': {
				'type': 'METHOD',
				'class': 'net.minecraft.client.renderer.LevelRenderer',
				'methodName': 'm_109695_',
				'methodDesc': '(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZIZ)V'
			},
			'transformer': setupRender
		}
	}	
}

function getLightColor(method) {
	var instructions = method.instructions;
	var returns = 0;

	for (var index = 0; index < instructions.size(); index++)
	{
		var insn = instructions.get(index);
		if (insn instanceof InsnNode && insn.getOpcode() == Opcodes.IRETURN)
		{
			instructions.insertBefore(insn, new VarInsnNode(Opcodes.ALOAD, 0));
			instructions.insertBefore(insn, new VarInsnNode(Opcodes.ALOAD, 1));
			instructions.insertBefore(insn, new VarInsnNode(Opcodes.ALOAD, 2));
			instructions.insertBefore(insn, new MethodInsnNode(Opcodes.INVOKESTATIC, 'com/legacy/lucent/core/asm_hooks/LevelRendererHooks', 'modifyLightColor', '(ILnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)I'));
			
			index += 4;
			returns++;
		}
	}

	if (returns > 0)
		ASMAPI.log('INFO', '[Lucent] Transformed LevelRenderer.getLightColor for ' + returns + ' returns');

	return method;
}

function compileChunksUntil(method) {
	var instructions = method.instructions;
	var insn = ASMAPI.findFirstMethodCall(method, ASMAPI.MethodType.VIRTUAL, 'java/lang/Boolean', 'booleanValue', '()Z');

	// Reversed
	instructions.insert(insn, new MethodInsnNode(Opcodes.INVOKESTATIC, 'com/legacy/lucent/core/asm_hooks/LevelRendererHooks', 'renderOffThread', '(ZLnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk;)Z'));
	instructions.insert(insn, new VarInsnNode(Opcodes.ALOAD, 7)); // load chunkrenderdispatcher$renderchunk

	ASMAPI.log('INFO', '[Lucent] Transformed LevelRenderer.compileChunksUntil');

	return method;
}

function setupRender(method) {
	var instructions = method.instructions;
	var insn = ASMAPI.findFirstMethodCall(method, ASMAPI.MethodType.VIRTUAL, 'java/lang/Boolean', 'booleanValue', '()Z');

	// Reversed
	instructions.insert(insn, new MethodInsnNode(Opcodes.INVOKESTATIC, 'com/legacy/lucent/core/asm_hooks/LevelRendererHooks', 'renderOffThread', '(ZLnet/minecraft/core/BlockPos;)Z'));
	instructions.insert(insn, new VarInsnNode(Opcodes.ALOAD, 32)); // load blockpos2

	ASMAPI.log('INFO', '[Lucent] Transformed LevelRenderer.setupRender');

	return method;
}

